% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenoFinder.R
\name{phenoFinder}
\alias{phenoFinder}
\title{Calculate pairwise similarities of phenoData between samples for a list
containing two ExpressionSets}
\usage{
phenoFinder(eset.pair, separator = ":", ...)
}
\arguments{
\item{eset.pair}{input: a list of ExpressionSets with two elements, or an
ExpressionSet.  If the two elements are identical, return the correlation
matrix for pairs of samples in the first element.  If not identical, return
pairs between the two elements.}

\item{separator}{a separator between dataset name (taken from the list
names) and sample name (taken from sampleNames(eset), to keep track of which
samples come from which dataset.}

\item{\dots}{Extra arguments passed on to phenoDist}
}
\value{
A matrix of similarities between the phenotypes of pairs of samples.
}
\description{
This function acts as a wrapper to phenoDist to handle cases of one
ExpressionSet, a list of two identical ExpressionSets, or a list of two
different ExpressionSets.
}
\examples{

library(curatedOvarianData)
data(GSE32063_eset)
data(GSE17260_eset)
esets2 <- list(JapaneseB=GSE32063_eset,
                Yoshihara2010=GSE17260_eset)

## standardize the sample ids to improve matching based on clinical annotation
esets2 <- lapply(esets2, function(X){
    X$alt_sample_name <- paste(X$sample_type, gsub("[^0-9]", "", X$alt_sample_name), sep="_")

## Removal of columns that cannot possibly match also helps duplicated patients to stand out
    pData(X) <- pData(X)[, !grepl("uncurated_author_metadata", colnames(pData(X)))]
    X <- X[, 1:20]  ##speed computations
    return(X) })

## See first six samples in both rows and columns
phenoFinder(esets2)[1:6, 1:6]

}
\author{
Levi Waldron, Markus Riester, Marcel Ramos
}
