% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEmpiricalDistribution.R
\name{plotEmpiricalDistribution}
\alias{plotEmpiricalDistribution}
\title{Plot the empirical distribution of the methylation beta vals or coverage}
\usage{
plotEmpiricalDistribution(
  bs,
  testCovariate = NULL,
  bySample = FALSE,
  type = "M",
  adj = 2.5
)
}
\arguments{
\item{bs}{a BSseq object}

\item{testCovariate}{character specifying the column name of the
\code{pData} slot of the BSseq object to include in the plot legend.}

\item{bySample}{logical whether to plot a separate line for each sample,
even if the grouping \code{testCovariate} is specified.
Default value is FALSE (so samples with the same value of 
\code{testCovariate} will be collapsed into the same line). If 
\code{testCovariate} is not specified, this parameter does not have an 
effect and samples are automatically plotted separately.}

\item{type}{a character indicating which type of density to plot - the 
methylation (beta) values ("M") or the coverage ("Cov"). Default is "M".}

\item{adj}{a numeric value for the \code{adjust} parameter to pass to the 
\code{geom_line} function. Specifies how smooth the make the function.}
}
\value{
a ggplot object
}
\description{
Uses ggplot2 to plot smoothed density histograms of methylation
proportions (beta values), or coverage. Methylation proportion densities
are weighted by coverage.
The number of curves plotted 
will be equal to the number of different values of \code{testCovariate},
unless \code{bySample} is TRUE. This can take quite some time to 
execute for a large object, so it is recommended to first take a random
sample of loci (say one million) before plotting.
}
\examples{

data(BS.chr21)

# plot beta values by sample group
plotEmpiricalDistribution(BS.chr21, testCovariate="CellType")

}
