% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_plotters.R
\name{multi_dittoDimPlot}
\alias{multi_dittoDimPlot}
\title{Generates dittoDimPlots for multiple features.}
\usage{
multi_dittoDimPlot(
  object,
  vars,
  ncol = NULL,
  nrow = NULL,
  axes.labels.show = FALSE,
  list.out = FALSE,
  OUT.List = NULL,
  ...,
  xlab = NA,
  ylab = NA,
  data.out = FALSE,
  do.hover = FALSE,
  legend.show = FALSE
)
}
\arguments{
\item{object}{A Seurat, SingleCellExperiment, or SummarizedExperiment object.}

\item{vars}{c("var1","var2","var3",...). A vector of vars ('var' in regular \code{\link{dittoDimPlot}}) from which to generate the separate plots.}

\item{ncol, nrow}{Integer or NULL. How many columns or rows the plots should be arranged into.}

\item{axes.labels.show}{Logical. Whether axis labels should be shown.
Subordinate to \code{xlab} and \code{ylab}.}

\item{list.out}{Logical. (Default = FALSE) When set to \code{TRUE}, a list of the individual plots, named by the \code{vars} being shown in each, is output instead of the combined multi-plot.}

\item{OUT.List}{Deprecated. Use \code{list.out}}

\item{..., xlab, ylab, data.out, do.hover, legend.show}{other parameters passed to \code{\link{dittoDimPlot}}.}
}
\value{
A set of dittoDimPlots either arranged into a grid (default), or output as a list.
}
\description{
Generates dittoDimPlots for multiple features.
}
\details{
Given multiple 'var' parameters to \code{vars}, this function creates a \code{\link{dittoDimPlot}} for each one, with minor defaulting tweaks (see below).

By default, these dittoDimPlots are arranged into a grid.
Alternatively, if \code{list.out} is set to \code{TRUE}, they are output as a list with each plot named as the \code{vars} being shown.

All parameters that can be adjusted in dittoDimPlot can be adjusted here, but the only input that will change between plots is \code{var}.
}
\section{Slight tweaks to dittoDimPlot defaults}{

\itemize{
\item axes labels are not shown by default to save space (control with \code{axes.labels.show} or \code{xlab} and \code{ylab})
\item legends are also not shown to save space (control with \code{legend.show})
}
}

\examples{
example(importDittoBulk, echo = FALSE)

multi_dittoDimPlot(myRNA, c("gene1", "gene2", "clustering"))

# Control grid shape with ncol / nrow
multi_dittoDimPlot(myRNA, c("gene1", "gene2", "clustering"),
    nrow = 1)
    
# Output as list instead
multi_dittoDimPlot(myRNA, c("gene1", "gene2", "clustering"),
    list.out = TRUE)

}
\seealso{
\code{\link{multi_dittoDimPlotVaryCells}} for an alternate \code{\link{dittoDimPlot}} multi-plotter where the cells/samples are varied between plots.

\code{\link{dittoDimPlot}} for the base dittoDimPlot plotting function and details on all accepted inputs.
}
\author{
Daniel Bunis
}
