% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Demuxlet_Tools.R
\name{demux.calls.summary}
\alias{demux.calls.summary}
\title{Plots the number of annotations per sample, per lane}
\usage{
demux.calls.summary(
  object,
  singlets.only = FALSE,
  main = "Sample Annotations by Lane",
  sub = NULL,
  ylab = "Annotations",
  xlab = "Sample",
  color = dittoColors()[2],
  theme = NULL,
  rotate.labels = TRUE,
  data.out = FALSE
)
}
\arguments{
\item{object}{A Seurat or SingleCellExperiment object}

\item{singlets.only}{Whether to only show data for cells called as singlets by demuxlet. Default is TRUE. Note: if doublets are included, only one of their sample calls will be used.}

\item{main}{plot title. Default = "Sample Annotations by Lane"}

\item{sub}{plot subtitle}

\item{ylab}{y axis label, default is "Annotations"}

\item{xlab}{x axis label, default is "Sample"}

\item{color}{bars color. Default is the dittoColors skyBlue.}

\item{theme}{A complete ggplot theme. Default is a slightly modified theme_bw().}

\item{rotate.labels}{whether sample names / x-axis labels should be rotated or not. Default is TRUE.}

\item{data.out}{Logical, whether underlying data for the plot should be output instead of the plot itself.}
}
\value{
A faceted ggplot summarizing how many cells in each lane were anotated to each sample.
Assumes that the Sample calls of each cell, and which lane each cell belonged to, are stored in 'Sample' and 'Lane' metadata slots, respectively, as would be the case if demuxlet information was imported with \code{\link{importDemux}}.

Alternatively, value will be a data.frame containing the underlying data if \code{data.out = TRUE} is provided.
}
\description{
Plots the number of annotations per sample, per lane
}
\examples{
example(importDemux, echo = FALSE)

demux.calls.summary(myRNA)

# Exclude doublets by setting 'singlets only = TRUE'
demux.calls.summary(myRNA,
    singlets.only = TRUE)

# To return the underlying data.frame
demux.calls.summary(myRNA, data.out = TRUE)

}
\seealso{
\code{\link{demux.SNP.summary}} for plotting the number of SNPs measured per cell.
This is the other Demuxlet-associated QC visualization included with dittoSeq.

\code{\link{importDemux}}, for how to import relevant demuxlet information as metadata.

Kang et al. Nature Biotechnology, 2018 \url{https://www.nature.com/articles/nbt.4042} for more information about the demuxlet cell-sample deconvolution method.
}
\author{
Daniel Bunis
}
