% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log2_FC.R
\name{log2_FC}
\alias{log2_FC}
\title{Compute FCs and log2-FCs.}
\usage{
log2_FC(
  res,
  x,
  name_assays_expression = "cpm",
  name_group = "group_id",
  name_cluster = "cluster_id"
)
}
\arguments{
\item{res}{a \code{\linkS4class{data.frame}} with results as returned from \code{\link{distinct_test}}.}

\item{x}{a \code{linkS4class{SummarizedExperiment}} or a \code{linkS4class{SingleCellExperiment}} object.}

\item{name_assays_expression}{a character ("cpm" by default), 
indicating the name of the assays(x) element which stores the expression data (i.e., assays(x)$name_assays_expression).
We strongly encourage using normalized data, such as counts per million (CPM).
Do not use logarithm transformed data to compute FCs.}

\item{name_group}{a character ("group_id" by default), 
indicating the name of the colData(x) element which stores the group id of each cell (i.e., colData(x)$name_group).}

\item{name_cluster}{a character ("cluster_id" by default), 
indicating the name of the colData(x) element which stores the cluster id of each cell (i.e., colData(x)$name_cluster).}
}
\value{
A \code{\linkS4class{data.frame}} object, extending the results in `res`.
Two additional columns are added: FC_group1/group2 and log2FC_group1/group2, inicating the FC and log2-FC of group1/group2.
A FC > 1 (or log2FC > 0) indicates up-regulation of group1 (compared to group2); while a FC < 1 (or log2FC < 0) indicates down-regulation of group1 (compared to group2).
}
\description{
\code{log2_FC} extends the results obtained via \code{\link{distinct_test}}, by computing fold changes (FC) and log2-FC between conditions.
}
\examples{
# load pre-computed results (obtaines via `distinct_test`)
data("res", package = "distinct")
# load the input data:
data("Kang_subset", package = "distinct")

# We can optionally add the fold change (FC) and log2-FC between groups:
res = log2_FC(res = res,
  x = Kang_subset, 
  name_assays_expression = "cpm",
  name_group = "stim",
  name_cluster = "cell")

# Visualize significant results:
head(top_results(res))

}
\seealso{
\code{\link{distinct_test}}, \code{\link{top_results}}
}
\author{
Simone Tiberi \email{simone.tiberi@uzh.ch}
}
