% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extendedMapSeqlevels.R
\name{extendedMapSeqlevels}
\alias{extendedMapSeqlevels}
\title{Change naming style for a set of sequence names}
\usage{
extendedMapSeqlevels(
  seqnames,
  style = getOption("chrsStyle", "UCSC"),
  species = getOption("species", "homo_sapiens"),
  currentStyle = NULL,
  ...
)
}
\arguments{
\item{seqnames}{A character vector with the sequence names.}

\item{style}{A single character vector specifying the naming style to use
for renaming the sequence names.}

\item{species}{A single character vector with the species of interest: it has
to match the valid species names supported in GenomeInfoDb. See
\code{names(GenomeInfoDb::genomeStyles())}. If \code{species = NULL},
a guess will be made using the available information in GenomeInfoDb.}

\item{currentStyle}{A single character vector with the currently used
naming style. If \code{NULL}, a guess will be made from the naming styles
supported by \code{species}.}

\item{...}{Arguments passed to other methods and/or advanced arguments.
Advanced arguments:
\describe{
\item{verbose }{ If \code{TRUE} basic status updates will be printed along
the way.}
\item{chrsStyle }{ The naming style of the chromosomes. By default,
\code{UCSC}. See \link[GenomeInfoDb:seqlevelsStyle]{seqlevelsStyle}. Set to \code{NULL} to
disable this function. This is used when \code{style} is missing, which is
normally the case when \code{extendedMapSeqlevels} is called by other
functions.}
}}
}
\value{
A vector of sequence names using the specified naming \code{style}.
}
\description{
If available, use the information from GenomeInfoDb for your species of
interest to map the sequence names from the style currently used to another
valid style. For example, for Homo sapiens map '2' (NCBI style) to 'chr2'
(UCSC style). If the information from GenomeInfoDb is not available, the
original sequence names will be returned. To disable this functionality
specify set \code{chrsStyle} to \code{NULL}.
}
\details{
This function is inspired from \link[GenomeInfoDb:seqlevelsStyle]{mapSeqlevels}
with the difference that it will return the original sequence names if
the species, current naming style or target naming style are not supported
in GenomeInfoDb.

If you want to disable this function, set \code{chrsStyle} to \code{NULL}.
From other functions in derfinder that pass the
\code{...} argument to this function, use \code{chrsStyle = NULL}.
This can be useful when working
with organisms that are absent from GenomeInfoDb as documented in
\url{https://support.bioconductor.org/p/95521/}.
}
\examples{


## Without guessing any information
extendedMapSeqlevels("2", "UCSC", "Homo sapiens", "NCBI")

## Guessing the current naming style
extendedMapSeqlevels("2", "UCSC", "Homo sapiens")

## Guess species and current style
extendedMapSeqlevels("2", "NCBI")

## Guess species while supplying the current style.
## Probably an uncommon use-case
extendedMapSeqlevels("2", "NCBI", currentStyle = "TAIR10")

## Sequence names are unchanged when using an unsupported species
extendedMapSeqlevels("seq2", "NCBI", "toyOrganism")

## Disable extendedMapSeqlevels. This can be useful when working with
## organisms that are not supported by GenomeInfoDb
chrs <- c(
    "I", "II", "III", "IV", "IX", "V", "VI", "VII", "VIII", "X",
    "XI", "XII", "XIII", "XIV", "XV", "XVI", "XVII"
)
extendedMapSeqlevels(chrs, chrsStyle = NULL)
\dontrun{
## Set global species and style option
options("chrsStyle" = "UCSC")
options("species" = "homo_sapiens")

## Run using global options
extendedMapSeqlevels("2")
}

}
\author{
L. Collado-Torres
}
