% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_cluster.R
\name{define_cluster}
\alias{define_cluster}
\title{Define a cluster to use.}
\usage{
define_cluster(cores = "mc.cores", ...)
}
\arguments{
\item{cores}{The argument to use to define the number of cores. This is
useful for cases with nested parallelizations.}

\item{...}{Advanced arguments are:
\describe{
\item{mc.cores }{ If 1 (default), then \link[BiocParallel:SerialParam-class]{SerialParam} will
be used. If greater than 1, then it specifies the number of workers for
\link[BiocParallel:SnowParam-class]{SnowParam}.}
\item{mc.log }{ Passed to \code{log} when using
\link[BiocParallel:SnowParam-class]{SnowParam}.}
\item{BPPARAM.custom }{ If specified, that's the BPPARAM that will be used.}
}}
}
\value{
A BiocParallel *Param object
}
\description{
Define a cluster to use.
}
\details{
This function is used internally in many functions.
}
\examples{
## Use SerialParam()
define_cluster(mc.cores = 1)

## Note that BPPARAM.custom takes precedence
define_cluster(mc.cores = 2, BPPARAM.custom = BiocParallel::SerialParam())
}
\author{
Leonardo Collado-Torres
}
