% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCluster.R
\name{plotCluster}
\alias{plotCluster}
\title{Plot the coverage information surrounding a region cluster}
\usage{
plotCluster(
  idx,
  regions,
  annotation,
  coverageInfo,
  groupInfo,
  titleUse = "qval",
  txdb = NULL,
  p.ideogram = NULL,
  ...
)
}
\arguments{
\item{idx}{A integer specifying the index number of the region of interest.
This region is graphically highlighted by a red bar.}

\item{regions}{The \verb{$regions} output from
\link[derfinder:calculatePvalues]{calculatePvalues}.}

\item{annotation}{The output from running \link[bumphunter:matchGenes]{matchGenes}
on the output from \link[derfinder:calculatePvalues]{calculatePvalues}.}

\item{coverageInfo}{A DataFrame resulting from
\link[derfinder:loadCoverage]{loadCoverage} using \code{cutoff=NULL}.}

\item{groupInfo}{A factor specifying the group membership of each sample. It
will be used to color the samples by group.}

\item{titleUse}{Whether to show the p-value (\code{pval}), the q-value
(\code{qval}) or the FWER adjusted p-value (\code{fwer}) in the title. If
\code{titleUse=none} then no p-value or
q-value information is used; useful if no permutations were performed and
thus p-value and q-value information is absent.}

\item{txdb}{A transcript data base such as
\code{TxDb.Hsapiens.UCSC.hg19.knownGene}. If \code{NULL} then no annotation
information is used.}

\item{p.ideogram}{If \code{NULL}, the ideogram for hg19 is built for the
corresponding chromosome. Otherwise an ideogram resuling from
\link[ggbio:plotSingleChrom]{plotIdeogram}.}

\item{...}{Arguments passed to other methods and/or advanced arguments.
Advanced arguments:
\describe{
\item{maxExtend }{ The maximum number of base-pairs to extend the view (on
each side) before and after the region cluster of interest. For small region
clusters, the one side extension is equal to the width of the region
cluster.}
\item{colsubset }{ Column subset in case that it was specified in
\link[derfinder:preprocessCoverage]{preprocessCoverage}.}
\item{forceLarge }{ If \code{TRUE} then the data size limitations are
ignored.
The window size (region cluster width + 2 times \code{maxExtend}) has to be
less than 100 kb. Note that a single plot at the 300kb range can take around
2 hours to complete.}
}}
}
\value{
A ggplot2 plot that is ready to be printed out. Tecnically it is a
ggbio object. The region with the red bar is the one whose information is
shown in the title.
}
\description{
For a given region found in \link[derfinder:calculatePvalues]{calculatePvalues}, plot the
coverage for the cluster this region belongs to as well as some padding. The
mean by group is shown to facilitate comparisons between groups. If
annotation exists, you can plot the trancripts and exons (if any)
overlapping in the vicinity of the region of interest.
}
\details{
See the parameter \code{significantCut} in
\link[derfinder:calculatePvalues]{calculatePvalues} for how the significance cutoffs are
determined.
}
\examples{
## Load data
library("derfinder")

## Annotate the results with bumphunter::matchGenes()
library("bumphunter")
library("TxDb.Hsapiens.UCSC.hg19.knownGene")
library("org.Hs.eg.db")
genes <- annotateTranscripts(
    txdb = TxDb.Hsapiens.UCSC.hg19.knownGene,
    annotationPackage = "org.Hs.eg.db"
)
annotation <- matchGenes(x = genomeRegions$regions, subject = genes)

## Make the plot
plotCluster(
    idx = 1, regions = genomeRegions$regions, annotation = annotation,
    coverageInfo = genomeDataRaw$coverage, groupInfo = genomeInfo$pop,
    txdb = TxDb.Hsapiens.UCSC.hg19.knownGene
)
## Resize the plot window and the labels will look good.
\dontrun{
## For a custom plot, check the ggbio and ggplot2 packages.
## Also feel free to look at the code for this function:
plotCluster
}

}
\seealso{
\link[derfinder:loadCoverage]{loadCoverage}, \link[derfinder:calculatePvalues]{calculatePvalues},
\link[bumphunter:matchGenes]{matchGenes}, \link[ggbio:plotSingleChrom]{plotIdeogram}
}
\author{
Leonardo Collado-Torres
}
