% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_decontPro.R
\name{plotDensity}
\alias{plotDensity}
\title{Density of each ADT, raw counts overlapped with decontaminated counts}
\usage{
plotDensity(counts, decontaminated_counts, features, file = NULL)
}
\arguments{
\item{counts}{original count matrix of nADT x nDroplet.}

\item{decontaminated_counts}{decontaminated count matrix.}

\item{features}{names of ADT to plot}

\item{file}{file name to save plot into a pdf. If omit, return \code{ggplot}
object.}
}
\value{
Return a pdf file named \code{file} or a \code{ggplot} object.
}
\description{
Density of each ADT, raw counts overlapped with decontaminated counts
}
\examples{
# Simulate a dataset with 3 cells and 2 ADTs
counts <- matrix(c(60, 72, 52, 49, 89, 112),
                 nrow = 2,
                 dimnames = list(c('CD3', 'CD4'),
                                 c('CTGTTTACACCGCTAG',
                                   'CTCTACGGTGTGGCTC',
                                   'AGCAGCCAGGCTCATT')))

decontaminated_counts <- matrix(c(58, 36, 26, 45, 88, 110),
                                nrow = 2,
                                dimnames = list(c('CD3', 'CD4'),
                                                c('CTGTTTACACCGCTAG',
                                                  'CTCTACGGTGTGGCTC',
                                                  'AGCAGCCAGGCTCATT')))

plotDensity(counts,
            decontaminated_counts,
            c('CD3', 'CD4'))
}
