% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDiagnostics.R
\name{plotDiagnostics}
\alias{plotDiagnostics}
\title{Diagnostics for model fitting in \code{\link[=decemedip]{decemedip()}}}
\usage{
plotDiagnostics(
  decemedip_output,
  plot_type,
  model_fit_n_samples = 100,
  model_fit_label_size = 12,
  model_fit_align = "hv",
  ...
)
}
\arguments{
\item{decemedip_output}{The output from \code{\link[=decemedip]{decemedip()}} function.}

\item{plot_type}{A string value, either 'y_fit' or 'model_fit'. \code{plot_type='y_fit'}
provides the fitted MeDIP-seq read counts vs. fractional methylation values,
indicating the fitted relationship between MeDIP-seq counts and fractional methylation.
\code{plot_type='model_fit'} provides a set of diagnostic plots for the fitted Stan
model.}

\item{model_fit_n_samples}{Number of randomly selected posterior samples for
plotting the diagnostic plots of stan fit. For \code{plot_type = 'model_fit'}
only.}

\item{model_fit_label_size}{Label size in the plot grid. For \code{plot_type = 'model_fit'}
only. See the argument \code{label_size} in \link[cowplot:plot_grid]{cowplot::plot_grid} for details.}

\item{model_fit_align}{Specifies how graphs in the grid should be aligned. See
the argument \code{align} in \link[cowplot:plot_grid]{cowplot::plot_grid} for details.}

\item{...}{Additional arguments to be fed into \link[cowplot:plot_grid]{cowplot::plot_grid}
in the case of \code{plot_type = 'model_fit'}.}
}
\value{
An \code{ggplot} object.
}
\description{
Diagnostics for model fitting in \code{\link[=decemedip]{decemedip()}}
}
\examples{

data(pdx.counts.cts.se)
data(pdx.counts.anc.se)
# read counts of cell type-specific CpGs of the sample 'LuCaP_147CR'
counts_cts <- SummarizedExperiment::assays(pdx.counts.cts.se)$counts[, "LuCaP_147CR"]
# read counts of anchor CpGs of the sample 'LuCaP_147CR'
counts_anc <- SummarizedExperiment::assays(pdx.counts.anc.se)$counts[, "LuCaP_147CR"]

## The following function is commented due to Bioconductor's time constraints on package building
## Fit decemedip model
# output <- decemedip(counts_cts = counts_cts, counts_anc = counts_anc)
## Plot diagnostic plots
# plotDiagnostics(output, plot_type = "y_fit")

}
