% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeReferencePanel.R
\name{makeReferencePanel}
\alias{makeReferencePanel}
\title{Function for assembling a SummarizedExperiment object of reference panel in \strong{hg19} for
cell type deconvolution (which is used in \code{decemedip} function)}
\usage{
makeReferencePanel(
  row_ranges,
  beta_matrix,
  cpg_coords,
  col_names = NULL,
  row_names = NULL,
  col_data = NULL,
  row_data = NULL
)
}
\arguments{
\item{row_ranges}{A \code{GRanges} object that contains the genomic coordinates
of \emph{reference regions/sites}.}

\item{beta_matrix}{A matrix that contains the beta values of reference regions. \strong{Each row
is a region and each column is a cell type.} If \code{beta_matrix} has row names or column names,
the output \code{SummarizedExperiment} object will inherit them.}

\item{cpg_coords}{A \code{GRanges} object that contains genomic coordinates of
all CpGs in the genome. A ready-to-use CpG list for hg19 is available to download at
\url{https://github.com/nshen7/decemedip-experiments/blob/main/hg19.cpg.coords.rda}.
It is used for generating coloum \code{n_cpg_100bp} in the reference panel, which
represents CpG density around the reference CpG.}

\item{col_names}{An atomic vector of strings that indicates the column names, i.e.,
names of the cell types. Default is NULL. If not NULL, the column names of \code{beta_matrix}
will be overwritten by this argument.}

\item{row_names}{An atomic vector of strings that indicates the row names, i.e.,
names of the reference regions. Default is NULL. If not NULL, the row names of \code{beta_matrix}
will be overwritten by this argument.}

\item{col_data}{A \code{DataFrame} object that contains metadata for columns (i.e.,
cell types) if specified. Each row in \code{col_data} should contain info of a cell type
in \verb{beta_matrix\}. If input is a non-\code\{DataFrame} object, it will be converted
to a \code{DataFrame}. Default is NULL.}

\item{row_data}{A \code{DataFrame} object that contains metadata for row (i.e.,
reference regions) if specified. Each row in \code{row_data} should contain info of a
reference region in \verb{beta_matrix\}. If input is a non-\code\{DataFrame} object, it will
be converted to a \code{DataFrame}. Default is NULL.}
}
\value{
An \code{SummarizedExperiment} object with each row represents a reference region
and an assay named 'beta_matrix' that stores the beta values of reference regions.
}
\description{
Function for assembling a SummarizedExperiment object of reference panel in \strong{hg19} for
cell type deconvolution (which is used in \code{decemedip} function)
}
\examples{

row_ranges <- GenomicRanges::GRanges(
  seqnames = S4Vectors::Rle(c("chr1", "chr2", "chr3")),
  ranges = IRanges::IRanges(
    start = c(100, 200, 300),
    end = c(100, 200, 300)
  ),
  cpg_id = c("cpg_1", "cpg_2", "cpg_3") # CpG site IDs
)

cpg_coords <- GenomicRanges::GRanges(
  seqnames = S4Vectors::Rle(c("chr1", "chr1", "chr2", "chr2", "chr3", "chr3")),
  ranges = IRanges::IRanges(
    start = c(100, 101, 200, 201, 300, 301),
    end = c(100, 101, 200, 201, 300, 301)
  )
)

beta_matrix <- matrix(runif(6), nrow = 3)

makeReferencePanel(
  row_ranges = row_ranges,
  beta_matrix = beta_matrix,
  cpg_coords = cpg_coords
)

}
