% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\docType{data}
\name{hg19.ref.cts.se}
\alias{hg19.ref.cts.se}
\title{Hg19 genomic information of cell-type-specific marker CpGs inferred from DNA
methylation atlas published by Moss 2018 Nat. Commun.
(https://www.nature.com/articles/s41467-018-07466-6).}
\format{
An object of class \code{SummarizedExperiment}. rowData(hg19.ref.cts.se) contains
information of the selected probes.
}
\usage{
data(hg19.ref.cts.se)
}
\description{
Default reference cell type-specific markers used as default in
\code{\link{decemedip}}. This dataset represents a GRanges object that contains the collection
of Illumina HumanMethylation450K probes that have methylation level less than 0.1 or
greater than 0.9 in all tissue present in the atlas. Data source of the methylation atlas is
from the MethAtlas GitHub repo (https://github.com/nloyfer/meth_atlas). For details
of how the marker CpGs are selected, please refer to the decemedip manuscript.
}
\details{
All coordinates are in hg19.
}
\examples{
data(hg19.ref.cts.se)
hg19.ref.cts.se
}
\references{
Moss, J., Magenheim, J., Neiman, D. et al. Comprehensive human
cell-type methylation atlas reveals origins of circulating cell-free DNA in
health and disease. \emph{Nat Commun 9, 5068} (2018).
https://doi.org/10.1038/s41467-018-07466-6
}
\keyword{datasets}
