% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spaghettiPlot_1GS.R
\name{spaghettiPlot1GS}
\alias{spaghettiPlot1GS}
\title{Spaghetti plot for Specific Gene Set}
\usage{
spaghettiPlot1GS(
  gs_index,
  gmt,
  expr_mat,
  design,
  var_time,
  var_indiv,
  sampleIdColname,
  var_group = NULL,
  var_subgroup = NULL,
  plotChoice = c("Medians", "Individual"),
  loess_span = 0.75
)
}
\arguments{
\item{gs_index}{index of the specific gene set in \code{gmt}.}

\item{gmt}{a \code{list} of elements: \code{geneset}, \code{geneset.name} and
\code{geneset.description} (see \code{\link[GSA]{GSA.read.gmt}}).}

\item{expr_mat}{a \code{data.frame} with numerics of size \code{G x n} 
contraining the raw RNA-seq counts from \code{n} samples for \code{G} genes.}

\item{design}{a \code{data.frame} or \code{DFrame} containing the information 
of each sample (SampleID).}

\item{var_time}{the \code{time} or \code{visit} variable contained in 
\code{design}.}

\item{var_indiv}{the patient variable contained in \code{design} data.}

\item{sampleIdColname}{a character string indicating the name of the sample ID 
variable in \code{design} to be matched with the \code{colnames} of \code{expr_mat}}

\item{var_group}{a group variable in \code{design} data to divide into two 
facets. Default is \code{NULL}.}

\item{var_subgroup}{a subgroup variable in \code{design} data to add 2 curves 
on plot for each subgroup. Default is \code{NULL}.}

\item{plotChoice}{to choose which type of plot (either \code{"Medians"}, 
\code{"Individual"} or both). Default is \code{c("Medians", "Individual")}.}

\item{loess_span}{smoothing span. Default is \code{0.75}.}
}
\value{
a ggplot2 plot object
}
\description{
Spaghetti plot for Specific Gene Set
}
\examples{
data(baduel_5gs) 
design$Indiv <- design$Population:design$Replicate
design$Vern <- ifelse(design$Vernalized, "Vernalized", "Non-vernalized")

library(ggplot2)
spaghettiPlot1GS(gs_index = 3, gmt = baduel_gmt, expr_mat = log2(expr_norm_corr+1), 
  design = design, var_time = AgeWeeks, var_indiv = Indiv, 
  sampleIdColname = "sample", var_group=Vern, var_subgroup=Population, 
  plotChoice = "Medians", loess_span= 1.5) +
  xlab("Age (weeks)") + guides(color= "none")
}
