% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_rarity.R
\name{step_filter_by_rarity}
\alias{step_filter_by_rarity}
\alias{step_filter_by_rarity,Recipe-method}
\alias{step_filter_by_rarity,PrepRecipe-method}
\title{Filter taxa by rarity}
\usage{
step_filter_by_rarity(rec, threshold = 0.01, id = rand_id("filter_by_rarity"))

\S4method{step_filter_by_rarity}{Recipe}(rec, threshold = 0.01, id = rand_id("filter_by_rarity"))

\S4method{step_filter_by_rarity}{PrepRecipe}(rec, threshold = 0.01, id = rand_id("filter_by_rarity"))
}
\arguments{
\item{rec}{A Recipe object. The step will be added to the sequence of
operations for this Recipe.}

\item{threshold}{The rarity threshold for filtering taxa, expressed as a
proportion of the total number of samples. For example, a threshold of 0.01
means that a taxon must be present in less than 1\% of the samples to be
retained. The default value is 0.01.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
A Recipe object that has been filtered based on rarity.
}
\description{
This is a convenience function around the filter_taxa function. It is
designed to speed up filtering complex experimental objects with one function
call. In the case of run_filter_by_rarity, the filtering will be based on the
rarity of each taxon. The taxa retained in the dataset are those where the
sum of their rarity is less than the provided threshold.
}
\details{
The function calculates the rarity of all taxa in the phyloseq
object as the proportion of samples in which they are present. It then
compares this rarity to the threshold. If a taxon's rarity is greater than
the threshold, that taxon is removed from the phyloseq object.
}
\note{
This function modifies \code{rec} in place, you might want to make a copy of
\code{rec} before modifying it if you need to preserve the original object.
}
\examples{
data(metaHIV_phy)

## Init Recipe
rec <- recipe(metaHIV_phy, "RiskGroup2", "Phylum")
rec

## Define step_filter_by_rarity step with default parameters
rec <- step_filter_by_rarity(rec, threshold = 0.01)
rec
}
\seealso{
\code{\link[phyloseq]{filter_taxa}}

Other filter phy steps: 
\code{\link{step_filter_by_abundance}()},
\code{\link{step_filter_by_prevalence}()},
\code{\link{step_filter_by_variance}()},
\code{\link{step_filter_taxa}()}
}
\concept{filter phy steps}
