% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aldex2.R
\name{step_aldex}
\alias{step_aldex}
\alias{step_aldex,Recipe-method}
\alias{step_aldex,PrepRecipe-method}
\title{ALDEx2 analysis}
\usage{
step_aldex(
  rec,
  max_significance = 0.05,
  mc.samples = 128,
  denom = "all",
  rarefy = FALSE,
  id = rand_id("aldex")
)

\S4method{step_aldex}{Recipe}(
  rec,
  max_significance = 0.05,
  mc.samples = 128,
  denom = "all",
  rarefy = FALSE,
  id = rand_id("aldex")
)

\S4method{step_aldex}{PrepRecipe}(
  rec,
  max_significance = 0.05,
  mc.samples = 128,
  denom = "all",
  rarefy = FALSE,
  id = rand_id("aldex")
)
}
\arguments{
\item{rec}{A Recipe object. The step will be added to the sequence of
operations for this Recipe.}

\item{max_significance}{Benjamini-Hochberg corrected P value of Welch’s t
test cutoff.}

\item{mc.samples}{The number of Monte Carlo instances to use to estimate the
underlying distributions; since we are estimating central tendencies, 128
is usually sufficient, but larger numbers may be .}

\item{denom}{An any variable (all, iqlr, zero, lvha, median, user) indicating
features to use as the denominator for the Geometric Mean calculation The
default "all" uses the geometric mean abundance of all features. Using
"median" returns the median abundance of all features. Using "iqlr" uses
the features that are between the first and third quartile of the variance
of the clr values across all samples. Using "zero" uses the non-zero
features in each grop as the denominator. This approach is an extreme case
where there are many nonzero features in one condition but many zeros in
another. Using "lvha" uses features that have low variance (bottom
quartile) and high relative abundance (top quartile in every sample). It is
also possible to supply a vector of row indices to use as the denominator.
Here, the experimentalist is determining a-priori which rows are thought to
be invariant. In the case of RNA-seq, this could include ribosomal protein
genes and and other house-keeping genes. This should be used with caution
because the offsets may be different in the original data and in the data
used by the function because features that are 0 in all samples are removed
by aldex.clr.}

\item{rarefy}{Boolean indicating if OTU counts must be rarefyed. This
rarefaction uses the standard R sample function to resample from the
abundance values in the otu_table component of the first argument, physeq.
Often one of the major goals of this procedure is to achieve parity in
total number of counts between samples, as an alternative to other formal
normalization procedures, which is why a single value for the sample.size
is expected. If 'no_seed', rarefaction is performed without a set seed.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An object of class \code{Recipe}
}
\description{
A differential abundance analysis for the comparison of two or more
conditions. For example, single-organism and meta-RNA-seq high-throughput
sequencing assays, or of selected and unselected values from in-vitro
sequence selections. Uses a Dirichlet-multinomial model to infer abundance
from counts, that has been optimized for three or more experimental
replicates. Infers sampling variation and calculates the expected false
discovery rate given the biological and sampling variation using the Wilcox
rank test or Welches t-test (aldex.ttest) or the glm and Kruskal Wallis tests
(aldex.glm). Reports both P and fdr values calculated by the Benjamini
Hochberg correction (Not supported in \code{dar} package).
}
\details{
The run_aldex function is a wrapper that performs log-ratio
transformation and statistical testing in a single line of code.
Specifically, this function: (a) generates Monte Carlo samples of the
Dirichlet distribution for each sample, (b) converts each instance using a
log-ratio transform, then (c) returns test results for two sample (Welch's
t, Wilcoxon) test. This function also estimates effect size for two sample
analyses.
}
\examples{
data(metaHIV_phy)

## Init Recipe
rec <-
  recipe(metaHIV_phy, "RiskGroup2", "Phylum") |>
  step_subset_taxa(tax_level = "Kingdom", taxa = c("Bacteria", "Archaea")) |>
  step_filter_taxa(.f = "function(x) sum(x > 0) >= (0.4 * length(x))")

rec

## Define ALDEX step with default parameters and prep
rec <-
  step_aldex(rec) |>
  prep(parallel = FALSE)

rec

## Wearing rarefaction only for this step
rec <-
  recipe(metaHIV_phy, "RiskGroup2", "Species") |>
  step_aldex(rarefy = TRUE)

rec
}
\seealso{
Other Diff taxa steps: 
\code{\link{step_ancom}()},
\code{\link{step_corncob}()},
\code{\link{step_deseq}()},
\code{\link{step_lefse}()},
\code{\link{step_maaslin}()},
\code{\link{step_metagenomeseq}()},
\code{\link{step_wilcox}()}
}
\concept{Diff taxa steps}
