% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{find_intersections}
\alias{find_intersections}
\title{Finds common OTU between method results}
\usage{
find_intersections(rec, steps = steps_ids(rec, "da"))
}
\arguments{
\item{rec}{A Recipe object.}

\item{steps}{character vector with step ids to take in account}
}
\value{
tibble
}
\description{
Finds common OTU between method results
}
\examples{
data(test_prep_rec)

## From a PrepRecipe we can extract a tibble with all intersections
intersections <- find_intersections(test_prep_rec)
intersections

## Additionally, we can exclude some methods form the table
intersections <- find_intersections(
  test_prep_rec, 
  steps = steps_ids(test_prep_rec, "da")[-1]
)

intersections
}
