% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{export_steps}
\alias{export_steps}
\title{Export step parameters as json.}
\usage{
export_steps(rec, file_name)
}
\arguments{
\item{rec}{A Recipe object.}

\item{file_name}{The path and file name of the optout file.}
}
\value{
invisible
}
\description{
Export step parameters as json.
}
\examples{
data(metaHIV_phy)

## Create a Recipe with steps
rec <- 
  recipe(metaHIV_phy, "RiskGroup2", "Species") |>
  step_subset_taxa(tax_level = "Kingdom", taxa = c("Bacteria", "Archaea")) |>
  step_filter_taxa(.f = "function(x) sum(x > 0) >= (0.3 * length(x))") |>
  step_filter_by_prevalence(0.4) |>
  step_maaslin()
 
## Prep Recipe   
rec <- prep(rec, parallel = TRUE)

## Export to json file
export_steps(rec, tempfile(fileext = ".json"))
}
