% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.R
\name{scores}
\alias{scores}
\alias{probs}
\alias{label}
\alias{tech}
\alias{initial}
\title{Returns a specified object from the cytofQC SingleCellExperiment}
\usage{
scores(x, type = c("all", "bead", "debris", "doublet", "dead"))

probs(x, type = c("all", "bead", "debris", "doublet", "dead"))

label(x)

tech(
  x,
  type = c("all", "Bead", "DNA", "Viability", "Event_length", "Center", "Offset",
    "Width", "Residual")
)

initial(x, type = c("all", "bead", "debris", "doublet", "dead"))
}
\arguments{
\item{x}{A \code{SingleCellExperiment} created with \code{\link{readCytof}} 
with the scores and initial columns filled out for the event type of 
interest.}

\item{type}{Identifies the type of objects to be returned. For 
\code{scores} and \code{probs}, type can be one or more of 'bead', 
'dead', 'debris', or 'doublet'. For \code{tech} it can be any of the QC 
variables. It will return the numeric vector or \code{DataFrame} 
for the score(s) or probability for the specified event type(s). If the 
event types are not specified, the \code{DataFrame} containing all of the 
scores or all of the probability will be returned. This argument does 
nothing for \code{label}.}
}
\value{
For \code{probs}, \code{scores}, and \code{tech}, a numeric vector 
or \code{DataFrame} with the information for the event type(s) is returned. 

For \code{label}, a character vector containing the label for each event is 
returned.

For \code{tech}, a \code{DataFrame} containing the technical variables
used to determine the label of each event. The bead, DNA, and viability
variables have an arcsinh transform, Event_length is unchanged, and 
the Gaussian parameters have a log transform using \code{log1p}.
}
\description{
Returns a specified object from the cytofQC SingleCellExperiment
}
\examples{
data("raw_data", package = "CATALYST")
sce <- readCytof(raw_data, beads = "Beads", viability = c("cisPt1", "cisPt2"))
sce <- labelQC(sce)
table(label(sce))
cytofHist(scores(sce, type = 'bead'), label(sce), title = "Bead score")
}
