% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffexpData.R
\name{CytoKDEData}
\alias{CytoKDEData}
\title{Differentially expressed data by cytoKernel}
\usage{
CytoKDEData(object, by = c("features"))
}
\arguments{
\item{object}{a CytoK object from \code{CytoK}}

\item{by}{String specifying which adjusted p values
of the features to filter by. Default is "features".}
}
\value{
A list of \code{data.frame}'s or a \code{SummarizedExperiment}. 
If a \code{data.frame} was originally input into the
 \code{CytoK} function, a list with two elements, \code{DEdata}, 
\code{nonDEfeatures}, will be returned. If a
\code{SummarizedExperiment} was originally input, output will be a 
\code{SummarizedExperiment} with the filtered assay with
 one metadata object \code{nonDEfeatures} and four row meta-data
 \code{EffectSize}, \code{EffectSizeSD}, \code{pvalue} and 
 \code{padj}.
}
\description{
Select \code{CytoK} object according to the differentially 
expressed features identified by cytoKernel. Features are filtered
if their adjusted p values are greater than \code{CytoKalpha}.
}
\examples{
data <- cbind(matrix(rnorm(1200,mean=2, sd=1.5),
nrow=200, ncol=6), matrix(rnorm(1200,mean=5, sd=1.9),
nrow=200, ncol=6))
data_CytoK <- CytoK(object=data,
group_factor = rep(c(0,1), each=6), lowerRho=2,
upperRho=12,gridRho=4,alpha = 0.05,
featureVars = NULL)
CytoKDEData(data_CytoK, by = "features")

}
