% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phytoFilterClass.R
\name{summaries,DebrisFilter-method}
\alias{summaries,DebrisFilter-method}
\title{takes a flowframes, a vector of channels, cluster indicator and return 
desired summaries per cluster}
\usage{
\S4method{summaries}{DebrisFilter}(object, channels = NULL)
}
\arguments{
\item{object}{An object of class MarginEvents to be summarised.}

\item{channels}{channels whose summaries are to be computed}
}
\value{
list containing the required summaries
}
\description{
takes a flowframes, a vector of channels, cluster indicator and return 
desired summaries per cluster
}
\examples{
flowfile_path <- system.file("extdata", "B4_18_1.fcs", 
              package = "cyanoFilter",
              mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, emptyValue = FALSE,
                               dataset = 1) 
flowfile_nona <- cyanoFilter::noNA(x = flowfile)
flowfile_noneg <- cyanoFilter::noNeg(x = flowfile_nona)
flowfile_logtrans <- cyanoFilter::lnTrans(x = flowfile_noneg, 
c('SSC.W', 'TIME'))
cells_nonmargin <- cellMargin(flowframe = flowfile_logtrans, 
Channel = 'SSC.W',
           type = 'estimate', y_toplot = "FSC.HLin")
summaries(cells_nonmargin, 
c("RED.B.HLin", "YEL.B.HLin", "RED.R.HLin"))

}
