% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retain.R
\name{retain}
\alias{retain}
\title{Decides if a file should be retiained or removed based on its status.}
\usage{
retain(
  meta_files,
  make_decision = c("maxi", "mini", "unique"),
  Status = "Status",
  CellspML = "CellspML"
)
}
\arguments{
\item{meta_files}{dataframe from meta file that has been preprocessed by the 
\code{\link{goodFcs}} function.}

\item{make_decision}{decision to be made should more than one 
\eqn{cells/\mu L} be good.}

\item{Status}{column name in meta_files containing status obtained from the 
\code{\link{goodFcs}} function.}

\item{CellspML}{column name in meta_files containing \eqn{cells/\mu L} 
measurements.}
}
\value{
a character vector with entries "Retain" for a file to be retained 
        or "No!" for a file to be discarded.
}
\description{
Function to determine what files to retain and finally read 
             from the flow cytometer FCS file.
}
\details{
It is typically not known in advance which dilution level would 
         result in the desired \eqn{cells/\mu L}, therefore
         the samples are ran through the flow cytometer at two or more 
         dilution levels. Out of these, one has to decide which
         to retain and finally use for further analysis. This function and 
         \code{\link{goodFcs}} are to help you decide that.
         If more than one of the dilution levels are judged good, 
         the option \emph{make_decision = "maxi"} will give "Retain" to the
         row with the maximum \eqn{cells/\mu L} while the opposite occurs 
         for \emph{make_decision = "mini"}. \emph{make_decision = "unique"} 
         i there is only one measurement for that particular sample, 
         while \emph{make_decision = "maxi"}
         and \emph{make_decision = "mini"} should be used for files with more
         than one measurement for the sample in question.
}
\examples{
 require("stringr")
 metadata <- system.file("extdata", "2019-03-25_Rstarted.csv", 
 package = "cyanoFilter",
 mustWork = TRUE)
 metafile <- read.csv(metadata, skip = 7, stringsAsFactors = FALSE,
                      check.names = TRUE, encoding = "UTF-8")
 metafile <- metafile[, seq_len(65)] #first 65 columns contain useful information
 #extract the part of the Sample.ID that corresponds to BS4 or BS5
 metafile$Sample.ID2 <- stringr::str_extract(metafile$Sample.ID, "BS*[4-5]")
 #clean up the Cells.muL column
 names(metafile)[which(stringr::str_detect(names(metafile), "Cells."))] <- 
 "CellspML"
 metafile$Status <- cyanoFilter::goodFcs(metafile = metafile, col_cpml = 
 "CellspML",
 mxd_cellpML = 1000, mnd_cellpML = 50)
 metafile$Retained <- NULL
 # first 3 rows contain BS4 measurements at 3 dilution levels
 metafile$Retained[seq_len(3)] <- 
  cyanoFilter::retain(meta_files = metafile[seq_len(3),], 
 make_decision = "maxi",
 Status = "Status", CellspML = "CellspML")
 # last 3 rows contain BS5 measurements at 3 dilution levels as well
 metafile$Retained[seq(4, 6, by = 1)] <- 
   cyanoFilter::retain(meta_files = metafile[seq(4, 6, by = 1),], 
 make_decision = "maxi",
 Status = "Status", CellspML = "CellspML")


}
\seealso{
\code{\link{goodFcs}}
}
