% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phytoFilterClass.R
\name{reducedFlowframe,PhytopFilter-method}
\alias{reducedFlowframe,PhytopFilter-method}
\title{accesor method for reduced flowframe(PhytoFilter class)}
\usage{
\S4method{reducedFlowframe}{PhytopFilter}(x)
}
\arguments{
\item{x}{an object of class PhytoFilter}
}
\value{
reduced flowFrame method for PhytoFilter
#' @examples 
flowfile_path <- system.file("extdata", "B4_18_1.fcs", 
package = "cyanoFilter",
              mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, 
                               emptyValue = FALSE,
                               dataset = 1) 
flowfile_nona <- cyanoFilter::noNA(x = flowfile)
flowfile_noneg <- cyanoFilter::noNeg(x = flowfile_nona)
flowfile_logtrans <- cyanoFilter::lnTrans(x = flowfile_noneg, 
                      c('SSC.W', 'TIME'))
cells_nonmargin <- cellMargin(flowframe = flowfile_logtrans, 
                              Channel = 'SSC.W',
           type = 'estimate', y_toplot = "FSC.HLin")
cells_nodebris <- debrisNc(flowframe = reducedFlowframe(cells_nonmargin),
                            ch_chlorophyll = "RED.B.HLin",
                            ch_p2 = "YEL.B.HLin",
                            ph = 0.05)
phy1 <- phytoFilter(flowfile = reducedFlowframe(cells_nodebris),
              pig_channels = c("RED.B.HLin", "YEL.B.HLin", "RED.R.HLin"),
              com_channels = c("FSC.HLin", "SSC.HLin"))
reducedFlowframe(phy1)
}
\description{
accesor method for reduced flowframe(PhytoFilter class)
}
