% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneDgate.R
\name{oneDgate}
\alias{oneDgate}
\title{returns the labels stating the cluster of each row in a flowfile.}
\usage{
oneDgate(flowfile, togate)
}
\arguments{
\item{flowfile}{flowframe after debris are removed.}

\item{togate}{channels detected to have more than one peak present. 
Provide by the \code{\link{getChannel}} function.}
}
\value{
list of indicators for cells above and below an estimated threshold
}
\description{
returns the labels stating the cluster of each row in a flowfile.
}
\examples{
flowfile_path <- system.file("extdata", "B4_18_1.fcs", 
                  package = "cyanoFilter",
              mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, emptyValue = FALSE,
                               dataset = 1) 
flowfile_nona <- cyanoFilter::noNA(x = flowfile)
flowfile_noneg <- cyanoFilter::noNeg(x = flowfile_nona)
flowfile_logtrans <- cyanoFilter::lnTrans(x = flowfile_noneg, 
c('SSC.W', 'TIME'))
oneDgate(flowfile, 'RED.B.HLin')

}
