% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDeepSpCas9Scores.R
\name{getDeepSpCas9Scores}
\alias{getDeepSpCas9Scores}
\title{Calculate on-target sgRNA activity scores for SpCas9 using DeepSpCas9}
\usage{
getDeepSpCas9Scores(sequences, fork = FALSE)
}
\arguments{
\item{sequences}{Character vector of 30bp sequences needed for DeepSpCas9
scoring, see details below.}

\item{fork}{Set to \code{TRUE} to preserve changes to the R
configuration within the session.}
}
\value{
\strong{getDeepSpCas9Scores} returns a data.frame with
    \code{sequence} and \code{score} columns. The getDeepSpCas9Scores score
    takes on a value between 0 and 1. A higher score indicates higher
    knockout efficiency.
}
\description{
Calculate on-target sgRNA activity scores for
    CRISPR/Cas9-induced knockout using the DeepSpCas9 scoring method.
}
\details{
The input sequences for DeepSpCas9 scoring require 4 nucleotides
    upstream of the protospacer sequence, the protospacer sequence
    itself (20bp spacer sequence + 3bp PAM sequence ) and 3 nucleootides 
    downstream of the protospacer sequence, for a total of 30 nucleotides.
}
\examples{
if (interactive()){
flank5 <- "ACCG" #4bp
spacer <- "AATCGATGCTGATGCTAGAT" #20bp
pam    <- "AGG" #3bp
flank3 <- "AAT" #3bp
input  <- paste0(flank5, spacer, pam, flank3) 
results <- getDeepSpCas9Scores(input)
}
}
\references{
Kim HK, Kim Y, Lee S, et al. SpCas9 activity prediction by DeepSpCas9, 
    a deep learning–base model with high generalization performance.
    Science advances. 2019 Nov 6;5(11):eaax9249.
}
\author{
Jean-Philippe Fortin
}
