% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDeepCpf1Scores.R
\name{getDeepCpf1Scores}
\alias{getDeepCpf1Scores}
\title{Calculate on-target sgRNA activity scores for Cas12a using DeepCpf1}
\usage{
getDeepCpf1Scores(sequences, convertPAM = TRUE, fork = FALSE)
}
\arguments{
\item{sequences}{Character vector of 34bp sequences needed for DeepCpf1
scoring, see details below.}

\item{convertPAM}{Should non-canonical PAM sequences be converted to
TTTC? TRUE by default.}

\item{fork}{Set to \code{TRUE} to preserve changes to the R
configuration within the session.}
}
\value{
\strong{getDeepCpf1Scores} returns a data.frame with \code{sequence}
    and \code{score} columns. The DeepCpf1 score takes on a value between 0
    and 1. A higher score indicates higher knockout efficiency.
}
\description{
Calculate on-target sgRNA activity scores for
    CRISPR/Cas12a-induced knockout using the DeepCpf1 scoring method.
    Currently not supported on Windows machines.
}
\details{
The input sequences for DeepCpf1 scoring require 4 nucleotides
    upstream of the protospacer sequence, the protospacer sequence
    itself (4bp PAM sequence + 23bp spacer sequence) and 3 nucleotides 
    downstream of the protospacer sequence, for a total of 34 nucleotides.
    If \code{convertPAM} is set to \code{TRUE}, any non-canonical PAM
    sequence will be convert to TTTC for scoring purposes.
}
\examples{
if (interactive()){
flank5 <- "ACCG" #4bp
pam    <- "TTTT" #4bp
spacer <- "AATCGATGCTGATGCTAGATATT" #23bp
flank3 <- "AAG" #4bp
input  <- paste0(flank5, pam, spacer, flank3) 
results <- getDeepCpf1Scores(input)
}

}
\references{
Kim, H., Min, S., Song, M. et al. Deep learning improves prediction of
    CRISPR–Cpf1 guide RNA activity. Nat Biotechnol 36, 239–241 (2018).
    \url{https://doi.org/10.1038/nbt.4061}.
}
\author{
Jean-Philippe Fortin
}
