% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queryTxObject.R
\name{queryTss}
\alias{queryTss}
\title{Convenience function to search for TSS coordinates.}
\usage{
queryTss(tssObject, queryColumn, queryValue, tss_window = NULL)
}
\arguments{
\item{tssObject}{A \linkS4class{GRanges} containing genomic positions
of transcription starting sites (TSSs).}

\item{queryColumn}{String specifying which column of \code{mcols(tssObject)}
should be searched for.}

\item{queryValue}{Character vector specifying the values to search for
in \code{tssObject[[queryColumn]]}.}

\item{tss_window}{Numeric vector of length 2 establishing the genomic
region to return. The value pair sets the 5 prime and 3 prime limits,
respectively, of the genomic region with respect to the TSS. Use
negative value(s) to set limit(s) upstream of the TSS. Default is
\code{c(-500, 500)}, which includes 500bp upstream and downstream of
the TSS.}
}
\value{
A \linkS4class{GRanges} object. Searches yielding no results will
    return an empty \linkS4class{GRanges} object.
}
\description{
Convenience function to search for TSS coordinates.
}
\examples{

data(tssObjectExample, package="crisprDesign")
queryTss(tssObjectExample,
         queryColumn="gene_symbol",
         queryValue="IQSEC3")


}
\seealso{
\code{\link{queryTxObject}} for querying gene annotations.
}
\author{
Luke Hoberecht, Jean-Philippe Fortin
}
