% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsDesign.R
\name{designOpsLibrary}
\alias{designOpsLibrary}
\title{Design gRNA library for optical pooled screening}
\usage{
designOpsLibrary(
  df,
  n_guides = 4,
  gene_field = "gene",
  min_dist_edit = 2,
  dist_method = c("hamming", "levenshtein"),
  splitByChunks = FALSE
)
}
\arguments{
\item{df}{data.frame containing information about candidate
gRNAs from which to build the OPS library. See details.}

\item{n_guides}{Integer specifying how many gRNAs per
gene should be selected. 4 by default.}

\item{gene_field}{String specifying the column in \code{df}
specifying gene names.}

\item{min_dist_edit}{Integer specifying the minimum distance edit
required for barcodes to be considered dissimilar. Barcodes that
have edit distances less than the min_dist_edit will not be
included in the library. 2 by default.}

\item{dist_method}{String specifying distance method. 
Must be either "hamming" (default) or "levenshtein".}

\item{splitByChunks}{Should distances be calculated in a chunk-wise
manner? FALSE by default. Highly recommended when the set of query
barcodes is large to reduce memory footprint.}
}
\value{
A subset of the \code{df} containing the gRNAs
    selected for the OPS library.
}
\description{
Design gRNA library for optical pooled screening
}
\examples{
data(guideSetExample, package="crisprDesign")
guideSet <- unique(guideSetExample)
guideSet <- addOpsBarcodes(guideSet)
guideSet <- guideSet[1:200]

df <- data.frame(ID=names(guideSet),
                 spacer=spacers(guideSet, as.character=TRUE),
                 opsBarcode=as.character(guideSet$opsBarcode))

# Creating mock gene:
df$gene <- rep(paste0("gene",1:10),each=20)
df$rank <- rep(1:20,10)
opsLib <- designOpsLibrary(df)

}
\author{
Jean-Philippe Fortin
}
