% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/addGeneAnnotation.R,
%   R/addSNPAnnotation.R
\name{addSNPAnnotation}
\alias{addSNPAnnotation}
\alias{addGeneAnnotation,NULL-method}
\alias{addSNPAnnotation,GuideSet-method}
\alias{addSNPAnnotation,PairedGuideSet-method}
\alias{addSNPAnnotation,NULL-method}
\title{Add SNP annotation to a \linkS4class{GuideSet} object}
\usage{
addSNPAnnotation(object, ...)

\S4method{addGeneAnnotation}{NULL}(object)

\S4method{addSNPAnnotation}{GuideSet}(object, snpObject, maf = 0.01)

\S4method{addSNPAnnotation}{PairedGuideSet}(object, snpObject, maf = 0.01)

\S4method{addSNPAnnotation}{NULL}(object)
}
\arguments{
\item{object}{A \linkS4class{GuideSet} object or a 
\linkS4class{PairedGuideSet} object.}

\item{...}{Additional arguments, currently ignored.}

\item{snpObject}{Either a character string specfying a path to a VCF file
or a GRanges object.}

\item{maf}{Minimum minor allele frequency to report (for a least one source
among 1000Genomes and TOPMED). Must be between 0 and 1 (exclusive).}
}
\value{
\code{guideSet} appended with \code{hasSNP} column and \code{snps}
    list-column, both stored in \code{mcols{guideSet}}.
}
\description{
Add SNP annotation to a \linkS4class{GuideSet} object.
   Only available for sgRNAs designed for human genome.
}
\details{
The different columns stored in
\code{mcols(guideSet)[["snps"]]} are:

\itemize{
\item \code{ID} sgRNA ID.
\item \code{rs} Reference SNP cluster ID (e.g. rs17852242) 
\item \code{rs_site} Genomic coordinate of the SNP.
\item \code{rs_site_rel} Position of SNP relative to the PAM site.
\item \code{allele_ref} DNAString specifying the SNP reference allele.
\item \code{allele_minor} DNAString specifying the SNP minor allele.
\item \code{MAF_1000G} Minor allele frequency in the 1000 Genomes project.
\item \code{MAF_TOPMED} Minor allele frequency in the TOPMed project.
\item \code{type} Type of SNP (\code{"ins"}: insertion, \code{"del"}:
    deletion).
\item \code{length} Length of SNP in nucleotides.
}
}
\examples{

vcf <- system.file("extdata",
                   file="common_snps_dbsnp151_example.vcf.gz",
                   package="crisprDesign")
data(guideSetExample, package="crisprDesign")
guideSet <- addSNPAnnotation(guideSetExample, snpObject=vcf)

}
\seealso{
\code{link{snps}} to retrieve an existing SNP annotation
    stored in a \linkS4class{GuideSet} object. See details section for a 
    description of the different columns.
}
