% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/addRestrictionEnzymes.R
\name{addRestrictionEnzymes}
\alias{addRestrictionEnzymes}
\alias{addRestrictionEnzymes,GuideSet-method}
\alias{addRestrictionEnzymes,PairedGuideSet-method}
\alias{addRestrictionEnzymes,NULL-method}
\title{Restriction enzyme recognition sites in spacer sequences}
\usage{
addRestrictionEnzymes(object, ...)

\S4method{addRestrictionEnzymes}{GuideSet}(
  object,
  enzymeNames = NULL,
  patterns = NULL,
  includeDefault = TRUE,
  flanking5 = "ACCG",
  flanking3 = "GTTT"
)

\S4method{addRestrictionEnzymes}{PairedGuideSet}(
  object,
  enzymeNames = NULL,
  patterns = NULL,
  includeDefault = TRUE,
  flanking5 = "ACCG",
  flanking3 = "GTTT"
)

\S4method{addRestrictionEnzymes}{NULL}(object)
}
\arguments{
\item{object}{A \linkS4class{GuideSet} or a 
\linkS4class{PairedGuideSet} object.}

\item{...}{Additional arguments, currently ignored.}

\item{enzymeNames}{Character vector of enzyme names.}

\item{patterns}{Optional named character vector for custom restriction site
patterns. Vector names are treated as enzymes names. See example.}

\item{includeDefault}{Should commonly-used enzymes be included?
TRUE by default.}

\item{flanking5, flanking3}{Character string indicating the 5' or 3' flanking
sequence, respectively, of the spacer sequence in the lentivial vector.}
}
\value{
Adds a DataFrame indicating
    whether cutting sites for the specified enzymes are found in the gRNA
    cassette (flanking sequences + spacer sequences).
}
\description{
Add restriction site enzymes annotation.
}
\details{
Restriction enzymes are often used for cloning purpose during the
    oligonucleotide synthesis of gRNA lentiviral constructs. Consequently,
    it is often necessary to avoid restriction sites of the used restriction
    enzymes in and around the spacer sequences. 
    \code{addRestrictionEnzymes} allows for
    flagging problematic spacer sequences by searching for restriction sites
    in the [flanking5][spacer][flanking3] sequence.
    
    The following enzymes are included when \code{includeDefault=TRUE}:
    EcoRI, KpnI, BsmBI, BsaI, BbsI, PacI, and MluI.
    
    Custom recognition sequences in \code{patterns} may use the IUPAC
    nucleotide code, excluding symbols indicating gaps. Avoid providing
    enzyme names in \code{patterns} that are already included by default (if
    \code{includeDefault=TRUE}) or given by \code{enzymeNames}. Patterns
    with duplicated enzyme names will be silently ignored, even if the
    recognition sequence differs. See example.
}
\examples{
data(SpCas9, package="crisprBase")
seq <- c("ATTTCCGGAGGCGAATTCGGCGGGAGGAGGAAGACCGG")
guideSet <- findSpacers(seq, crisprNuclease=SpCas9)

# Using default enzymes:
guideSet <- addRestrictionEnzymes(guideSet)

# Using custom enzymes:
guideSet <- addRestrictionEnzymes(guideSet,
                                  patterns=c(enz1="GGTCCAA",
                                             enz2="GGTCG"))

# Avoid duplicate enzyme names
guideSet <- addRestrictionEnzymes(guideSet,
                                  patterns=c(EcoRI="GANNTC")) # ignored

}
\seealso{
\code{\link{enzymeAnnotation}} to retrieve existing enzyme
    annotation from a \linkS4class{GuideSet} object.
}
\author{
Jean-Philippe Fortin, Luke Hoberecht
}
