% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateMismatches.R
\name{annotateMismatches}
\alias{annotateMismatches}
\title{Annotate mismatches between spacer and protospacer sequences}
\usage{
annotateMismatches(spacers, protospacers, rnase = FALSE)
}
\arguments{
\item{spacers}{A character vector specifying spacer sequences (gRNA).}

\item{protospacers}{A character vector specifying protospacer sequences
(target DNA).}

\item{rnase}{Is it for an RNAse? FALSE by default.
If TRUE, spacers and protospacers are expected to be
the reverse complement of each other.}
}
\value{
A data.frame storing spacer and protospacer columns,
    as well as number of mismatches, and positions for 
    the different mismatches, if any.
    Positions are relative to the 5' end of the 
    spacer sequences. For RNAses (e.g. CasRx), this means
    that a mismatch at position 1 corresponds to the last
    nucleotide of the protospacer sequence.
}
\description{
Annotate mismatches between spacer and protospacer sequences.
}
\examples{
spacers <- c("CCGGAGCGAGTTGCAGTAAGCAG",
    "GCCGGAGCGAGTTGCAGTAAGCA", 
    "GGCCGGAGCGAGTTGCAGTAAGC")

protospacers=c("CTGCTTACTGCAACTCGCTCTGG",
    "TGCTTAATGCAACCCGCTCCGGC", 
    "GCTTACTGCAACTCGCTCCGGCC")

ann <- annotateMismatches(spacers,
    protospacers,
    rnase=TRUE)

}
\author{
Jean-Philippe Fortin
}
