% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/CrisprNuclease-class.R
\docType{class}
\name{spacerLength}
\alias{spacerLength}
\alias{targetLength}
\alias{pamLength}
\alias{spacerGap}
\alias{hasSpacerGap}
\alias{spacerGap<-}
\alias{spacerLength<-}
\alias{pamSide}
\alias{pamSide<-}
\alias{pams}
\alias{pamIndices}
\alias{spacerIndices}
\alias{prototypeSequence}
\alias{CrisprNuclease-class}
\alias{CrisprNuclease}
\alias{show,CrisprNuclease-method}
\alias{pamLength,CrisprNuclease-method}
\alias{spacerLength,CrisprNuclease-method}
\alias{spacerLength<-,CrisprNuclease-method}
\alias{pamSide,CrisprNuclease-method}
\alias{pamSide<-,CrisprNuclease-method}
\alias{spacerGap,CrisprNuclease-method}
\alias{spacerGap<-,CrisprNuclease-method}
\alias{hasSpacerGap,CrisprNuclease-method}
\alias{targetLength,CrisprNuclease-method}
\alias{pams,CrisprNuclease-method}
\alias{pamIndices,CrisprNuclease-method}
\alias{spacerIndices,CrisprNuclease-method}
\alias{prototypeSequence,CrisprNuclease-method}
\title{An S4 class to represent a CRISPR nuclease.}
\usage{
spacerLength(object, ...)

targetLength(object, ...)

pamLength(object, ...)

spacerGap(object)

hasSpacerGap(object)

spacerGap(object) <- value

spacerLength(object) <- value

pamSide(object, ...)

pamSide(object) <- value

pams(object, ...)

pamIndices(object, ...)

spacerIndices(object, ...)

prototypeSequence(object, ...)

CrisprNuclease(
  nucleaseName,
  targetType = c("DNA", "RNA"),
  pams = NA_character_,
  weights = rep(1, length(pams)),
  metadata = list(),
  pam_side = NA_character_,
  spacer_gap = 0L,
  spacer_length = NA_integer_
)

\S4method{show}{CrisprNuclease}(object)

\S4method{pamLength}{CrisprNuclease}(object)

\S4method{spacerLength}{CrisprNuclease}(object)

\S4method{spacerLength}{CrisprNuclease}(object) <- value

\S4method{pamSide}{CrisprNuclease}(object)

\S4method{pamSide}{CrisprNuclease}(object) <- value

\S4method{spacerGap}{CrisprNuclease}(object)

\S4method{spacerGap}{CrisprNuclease}(object) <- value

\S4method{hasSpacerGap}{CrisprNuclease}(object)

\S4method{targetLength}{CrisprNuclease}(object)

\S4method{pams}{CrisprNuclease}(object, primary = TRUE, ignore_pam = FALSE, as.character = FALSE)

\S4method{pamIndices}{CrisprNuclease}(object)

\S4method{spacerIndices}{CrisprNuclease}(object)

\S4method{prototypeSequence}{CrisprNuclease}(object, primary = TRUE)
}
\arguments{
\item{object}{\linkS4class{CrisprNuclease} object.}

\item{...}{Additional arguments for class-specific methods}

\item{value}{For \code{spacerLength<-} and \code{gapLength<-}, must be 
a non-negative integer. For \code{pamSide}, must be either
'5prime' or '3prime'.}

\item{nucleaseName}{Name of the CRISPR nuclease.}

\item{targetType}{String specifying target type ("DNA" or "RNA").}

\item{pams}{Character vector of PAM sequence motifs
written from 5' to 3. If the point of cleavage has
been determined, the precise site is marked with ^.
Only letters in the IUPAC code are accepted.
For nucleases that cleave away from their
recognition sequence, the cleavage sites are indicated
in parentheses. See details for more information.}

\item{weights}{Optional numeric vector specifying relative weights
of the PAM sequences to specify cleavage probabilities.}

\item{metadata}{Optional list providing global metadata information.}

\item{pam_side}{String specifying the side of the PAM sequence
sequence with respect to the protospacer sequence. Must be either 
'3prime' (e.g. Cas9) or '5prime' (e.g. Cas12a)}

\item{spacer_gap}{Integer specifying the length (in nucleotides) between
the spacer sequence and the PAM sequence (e.g. 0 for Cas9 and Cas12a).}

\item{spacer_length}{Integer specifying the length of the spacer sequence}

\item{primary}{Should only the PAM sequence with the heighest weight
be returned? If no cleavage weights are stored in the
\linkS4class{CrisprNuclease} object, all sequences are returned.
TRUE by default.}

\item{ignore_pam}{Should all possible k-mer sequences for a given PAM length
be returned, irrespetively of the PAM sequence motifs stored in the
\linkS4class{CrisprNuclease} object? FALSE by default.}

\item{as.character}{Should the PAM sequences be returned as a 
character vector? FALSE by default.}
}
\value{
A CrisprNuclease object
}
\description{
An S4 class to represent a CRISPR nuclease.
}
\section{Functions}{
\itemize{
\item \code{CrisprNuclease()}: Create a \linkS4class{CrisprNuclease} object

}}
\section{Slots}{

\describe{
\item{\code{pam_side}}{String specifying the side of the PAM sequence
with respect to the protospacer sequence. Must be either 
'3prime' (e.g. SpCas9) or '5prime' (e.g. AsCas12a)}

\item{\code{spacer_length}}{Integer specifying the
length of the spacer sequence}

\item{\code{spacer_gap}}{Integer specifying the length (in nucleotides)
between the spacer sequence and the PAM sequence
(e.g. 0 for SpCas9 and AsCas12a).}
}}

\section{Constructors}{

    Use the constructor \code{link{CrisprNuclease}} to create
        a CrisprNuclease object.
}

\section{Accessors}{

\describe{
    \item{\code{nucleaseName}:}{To get the name of the CRISPR nuclease.} 
    \item{\code{spacerLength}:}{To return the length of the
        spacer sequence.}
    \item{\code{targetLength}:}{To return the length of the
        target sequence (protospacer + pam).}
    \item{\code{pamLength}:}{To return the length of the PAM sequence.}
    \item{\code{pamSide}:}{To return the side of the PAM sequence with
        respect to the spacer sequence.}
    \item{\code{spacerGap}:}{To return the length of the gap between the
        PAM and spacer sequences.}
    \item{\code{pams}:}{To return the list of PAM sequences.}
}
}

\section{Setters}{

\describe{
    \item{\code{spacerGap<-}:}{To change the length of the gap between the
        PAM and spacer sequences.}
    \item{\code{pamSide<-}:}{To change the side of the PAM sequence
        with respect to the protospacer sequence.}
    \item{\code{spacerLength<-}:}{To change the length of the spacer
        sequence.}
}
}

\section{Utility functions for genomic arithmetics}{

\describe{
    \item{\code{pamIndices}:}{To return the relative coordinates of the
        PAM sequence within the target sequence.}
    \item{\code{spacerIndices}:}{To return the relatiive coordinates of
        the spacer sequence within the target sequence.}
}
}

\examples{
SpCas9 <- CrisprNuclease("SpCas9",
                         pams=c("(3/3)NGG", "(3/3)NAG", "(3/3)NGA"),
                         weights=c(1, 0.2593, 0.0694),
                         metadata=list(description="Wildtype Streptococcus
                                       pyogenes Cas9 (SpCas9) nuclease"),
                         pam_side="3prime",
                         spacer_length=20)

}
