% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sce2matlist}
\alias{sce2matlist}
\title{SingleCellExperiment to list of matrices}
\usage{
sce2matlist(sce, splitby, to_include = NULL, whichmat = "counts")
}
\arguments{
\item{sce}{SingleCellExperiment that is to be separated into list of count matrices}

\item{splitby}{character; name of the attribute from colData that should be used to separate the SCE}

\item{to_include}{(optional) character vector; determines which values from the "splitby" column will be included in the outputted matlist. NULL is the default, and will result in selecting all elements}

\item{whichmat}{character; defaults to \code{counts}, can also use \code{logcounts} or \code{normcounts} if stored in the \code{sce} object}
}
\value{
list of matrices
}
\description{
SingleCellExperiment to list of matrices
}
\examples{
library(DuoClustering2018)
sce <- sce_full_Zhengmix4eq()
matlist <- sce2matlist(sce = sce, splitby = 'phenoid', whichmat = 'logcounts')
}
