% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.helland.subtypes.R
\name{get.helland.subtypes}
\alias{get.helland.subtypes}
\title{Get ovarian cancer subtypes as defined by Helland et al., 2011}
\usage{
get.helland.subtypes(expression.matrix, entrez.ids)
}
\arguments{
\item{expression.matrix}{A matrix of gene expression values with rows as
genes, columns as samples.}

\item{entrez.ids}{A vector of Entrez Gene IDs, corresponding to the rows of
\code{expression.matrix}}
}
\value{
A list with first value \code{Helland.subtypes} containing a factor
of subtype names; and second value \code{subtype.scores} containing a matrix
of subtype scores
}
\description{
Get ovarian cancer subtypes as defined by Helland et al., 2011
}
\examples{
library(Biobase)
data(GSE14764.eset)
expression.matrix <- exprs(GSE14764.eset)
entrez.ids <- as.character(fData(GSE14764.eset)$EntrezGene.ID)
get.helland.subtypes(expression.matrix, entrez.ids)
}
\references{
Helland et al. \emph{Deregulation of MYCN, LIN28B and LET7 in a
molecular subtype of aggressive high-grade serous ovarian cancers.}
PloS one (2011).
}
