% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.hao.subtypes.R
\name{get.hao.subtypes}
\alias{get.hao.subtypes}
\title{Get ovarian cancer subtypes as defined by Hao et al., 2017}
\usage{
get.hao.subtypes(expression.matrix, entrez.ids)
}
\arguments{
\item{expression.matrix}{A matrix of gene expression values with genes as
rows, samples as columns.}

\item{entrez.ids}{A vector of Entrez Gene IDs, corresponding to the rows of
\code{expression.matrix}.}
}
\value{
A list with first value \code{tissue} containing a factor
of subtype names (tissue of origin); and second value \code{score} containing
the tissue-of-origin score.
}
\description{
Get ovarian cancer subtypes as defined by Hao et al., 2017
}
\details{
Hao et al., 2017 derived a gene signature to predict the tissue 
of origin of ovarian tumors as either fallopian tube (FT) or ovarian surface
epithelium (OSE).

The authors found that expression patterns of tissue-specific genes, prognostic
genes, and molecular markers support a dualistic tissue origin of ovarian cancer, 
from either FT or OSE.

The subtype classifier considers 112 signature genes including 37 genes
upregulated in FT and 75 genes upregulated in OSE. A score is computed
that is designed to range from 0 to 1 for FT tumors, while OSE tumors have a 
score ranging from -1 to 0.
}
\examples{
library(Biobase)
data(GSE14764.eset)
expression.matrix <- exprs(GSE14764.eset)
entrez.ids <- as.character(fData(GSE14764.eset)$EntrezGene.ID)
get.hao.subtypes(expression.matrix, entrez.ids)
}
\references{
Hao et al. (2017) Integrated analysis reveals tubal- and
ovarian-originated serous ovarian cancer and predicts differential therapeutic
responses. Clinical Cancer Research, 23:7400-11.
}
\author{
Ludwig Geistlinger
}
