% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.consensus.subtypes.R
\name{get.consensus.subtypes}
\alias{get.consensus.subtypes}
\alias{margin}
\title{Get consensusOV ovarian cancer subtypes}
\usage{
get.consensus.subtypes(
  expression.matrix,
  entrez.ids,
  concordant.tumors.only = TRUE,
  remove.using.cutoff = FALSE,
  percentage.dataset.removed = 0.75,
  .training.dataset = consensus.training.dataset.full,
  .dataset.names.to.keep = names(esets.rescaled.classified.filteredgenes)
)

margin(rf.probs)
}
\arguments{
\item{expression.matrix}{A matrix of gene expression values with rows as
genes, columns as samples.}

\item{entrez.ids}{A vector of Entrez Gene IDs, corresponding to the rows of
\code{expression.matrix}}

\item{concordant.tumors.only}{Logical. Should the classifier trained only on 
tumors that are concordantly classified by Helland, Konecny, and Verhaak?
Defaults to TRUE.}

\item{remove.using.cutoff}{Specify whether to classify NA for samples that do
not meet a margin cutoff}

\item{percentage.dataset.removed}{If remove.using.cutoff is TRUE, then
classify this percentage of samples to NA based on margin values}

\item{.training.dataset}{ExpressionSet containing the training data. 
Defaults to the pooled dataset across selected MetaGxOvarian datasets.}

\item{.dataset.names.to.keep}{Names of MetaGxOvarian datasets to use for
training}

\item{rf.probs}{random forest probabilities for each subtype as returned
by \code{\link{get.consensus.subtypes}}}
}
\value{
\code{get.consensus.subtypes} returns a list with 
first value \code{consensusOV.subtypes} containing a
factor of subtype labels; and second value \code{rf.probs} containing a matrix
of subtype probabilities.

\code{margin} returns a numeric vector containing the classification margin 
scores, i.e. the difference between the top two subtype scores for each tumor.
}
\description{
Get consensusOV ovarian cancer subtypes
}
\examples{
library(Biobase)
data(GSE14764.eset)
expression.matrix <- exprs(GSE14764.eset)
entrez.ids <- as.character(fData(GSE14764.eset)$EntrezGene.ID)
sts <- get.consensus.subtypes(expression.matrix, entrez.ids)
margins <- margin(sts$rf.probs)

}
