% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functionsAnalysis.R
\name{overlapGO}
\alias{overlapGO}
\title{Similarity of two gene ontologies lists}
\usage{
overlapGO(GO1, GO2, method = c("cosine", "jaccard"), fdr = 0.01)
}
\arguments{
\item{GO1}{list of GOs for each independent component got from `getGO()`}

\item{GO2}{list of GOs for each independent component got from `getGO()`}

\item{method}{can be 'cosine' for non-parametric cosine similarity  or 
'jaccard' for Jaccadr index. See details}

\item{fdr}{FDR threshold for GOs that would be used in measures. 
Default value is 0.01}
}
\value{
a similarity matrix of cosine or Jaccard values, 
rows corresponds to independent components in `GO1`, 
columns to independent components in `GO2`.
}
\description{
Calculate similarity matrix of gene ontilogies (GOs) 
of independent components. The measure could be cosine similarity or
Jaccard index (see details)
}
\details{
Jaccard index is a measure of the similarity between two sets of data. 
It calculated as intersection divided by union \deqn{
  J(A, B) = \frac{|A \cap B|}{|A \cup B|}.
}
 Results are from 0 to 1.

Cosine similarity here is calculated in a non-parametric way: 
for two vectors of gene ontologies, the space is created as a union of GOs 
in both vectors.
Then, two rank vectors in this space created, 
most enriched GOs get the biggest rank and GOs from space not included in 
the GO vector get 0.
Cosine similarity is calculated between two scaled rank vectors. 
Such approach allows to
take the order of enriched GO into account.
Results are from -1 to 1. Zero means no similarity.
}
\examples{
\dontrun{
data("samples_data")
# Calculate ICA (run with ntry=1 for quick test, use more in real analysis)
cica1 <- consICA(samples_data, ncomp=5, ntry=1, show.every=0)
# Search enriched gene ontologies
cica1 <- getGO(cica1, db = "BP", ncores = 1)
# Calculate ICA and GOs for another dataset
cica2 <- consICA(samples_data[,1:100], ncomp=4, ntry=1, show.every=0) 
cica2 <- getGO(cica2, db = "BP", ncores = 1)
# Compare two lists of enriched GOs 
# Jaccard index
jc <- overlapGO(GO1 = cica1$GO$GOBP, GO2 = cica2$GO$GOBP, 
method = "jaccard", fdr = 0.01)
# Cosine similarity
cos_sim <- overlapGO(GO1 = cica1$GO$GOBP, GO2 = cica2$GO$GOBP, 
method = "cosine", fdr = 0.01)
}
}
\author{
Maryna Chepeleva
}
