% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/multiple_samples.R
\name{progressionTest_multipleSamples}
\alias{progressionTest_multipleSamples}
\alias{progressionTest_multipleSamples,matrix-method}
\alias{progressionTest_multipleSamples,SlingshotDataSet-method}
\alias{progressionTest_multipleSamples,SingleCellExperiment-method}
\alias{progressionTest_multipleSamples,PseudotimeOrdering-method}
\title{Differential Progression Test with multiple samples}
\usage{
progressionTest_multipleSamples(pseudotime, ...)

\S4method{progressionTest_multipleSamples}{matrix}(
  pseudotime,
  cellWeights,
  conditions,
  Samples,
  ...
)

\S4method{progressionTest_multipleSamples}{SlingshotDataSet}(pseudotime, conditions, Samples, ...)

\S4method{progressionTest_multipleSamples}{SingleCellExperiment}(pseudotime, conditions, Samples, ...)

\S4method{progressionTest_multipleSamples}{PseudotimeOrdering}(pseudotime, conditions, Samples, ...)
}
\arguments{
\item{pseudotime}{Can be either a \code{\link{SlingshotDataSet}} or a
\code{\link{SingleCellExperiment}} object or a matrix of pseudotime values,
each row represents a cell and each column represents a lineage.}

\item{...}{Other arguments passed to \code{\link{progressionTest}}.}

\item{cellWeights}{If `pseudotime` is a matrix of pseudotime values, this
represent the cell weights for each lineage. Ignored if `pseudotime` is not
a matrix.}

\item{conditions}{Either the vector of conditions, or a character indicating which
column of the metadata contains this vector.}

\item{Samples}{A vector assigning each cell to a sample. Samples must be shared across all conditions.}
}
\value{
The same object has the \code{\link{progressionTest}} with one more column per sample.
}
\description{
Test whether or not the pseudotime distribution are identical
within lineages between conditions, with samples not being confounded by conditions
}
\examples{
data('slingshotExample', package = "slingshot")
rd <- slingshotExample$rd
cl <- slingshotExample$cl
condition <- factor(rep(c('A','B'), length.out = nrow(rd)))
condition[110:139] <- 'A'
sds <- slingshot::slingshot(rd, cl)
samples <- sample(1:2, 140, replace = TRUE)
progressionTest_multipleSamples(pseudotime = sds, conditions = condition, Samples = samples)
}
