% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/multiple_samples.R
\name{fateSelectionTest_multipleSamples}
\alias{fateSelectionTest_multipleSamples}
\alias{fateSelectionTest_multipleSamples,matrix-method}
\alias{fateSelectionTest_multipleSamples,SlingshotDataSet-method}
\alias{fateSelectionTest_multipleSamples,SingleCellExperiment-method}
\alias{fateSelectionTest_multipleSamples,PseudotimeOrdering-method}
\title{Differential fate selection Test with multiple samples}
\usage{
fateSelectionTest_multipleSamples(cellWeights, ...)

\S4method{fateSelectionTest_multipleSamples}{matrix}(cellWeights, conditions, Samples, ...)

\S4method{fateSelectionTest_multipleSamples}{SlingshotDataSet}(cellWeights, conditions, Samples, ...)

\S4method{fateSelectionTest_multipleSamples}{SingleCellExperiment}(cellWeights, conditions, Samples, ...)

\S4method{fateSelectionTest_multipleSamples}{PseudotimeOrdering}(cellWeights, conditions, Samples, ...)
}
\arguments{
\item{cellWeights}{Can be either a \code{\link{SlingshotDataSet}}, a
\code{\link{SingleCellExperiment}} object or a matrix of cell weights
defining the probability that a cell belongs to a particular lineage.
Each row represents a cell and each column represents a lineage. If only a
single lineage, provide a matrix with one column containing all values of 1.}

\item{...}{Other arguments passed to \code{\link{fateSelectionTest}}.}

\item{conditions}{Either the vector of conditions, or a character indicating which
column of the metadata contains this vector.}

\item{Samples}{A vector assigning each cell to a sample. Samples must be shared across all conditions.}
}
\value{
The same object has the \code{\link{fateSelectionTest}} with one more column per sample.
}
\description{
Test whether or not the cell repartition between lineages is
independent of the conditions, with samples not being confounded by conditions
}
\examples{
data('slingshotExample', package = "slingshot")
rd <- slingshotExample$rd
cl <- slingshotExample$cl
condition <- factor(rep(c('A','B'), length.out = nrow(rd)))
condition[110:139] <- 'A'
sds <- slingshot::slingshot(rd, cl)
samples <- sample(1:2, 140, replace = TRUE)
fateSelectionTest_multipleSamples(cellWeights = sds, conditions = condition, Samples = samples)
}
