% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylolmMethods.R
\name{writeNormalization}
\alias{writeNormalization}
\title{Generate a \code{.Rmd} file containing code to normalize data.}
\usage{
writeNormalization(
  norm.method,
  length.normalization,
  data.transformation,
  codefile
)
}
\arguments{
\item{norm.method}{The between-sample normalization method used to compensate for varying library sizes and composition in the differential expression analysis. The normalization factors are calculated using the \code{calcNormFactors} of the \code{edgeR} package. Possible values are \code{"TMM"}, \code{"RLE"}, \code{"upperquartile"} and \code{"none"}}

\item{length.normalization}{one of "none" (no correction), "TPM", "RPKM" (default). See details.}

\item{data.transformation}{one of "log2", "asin(sqrt)" or "sqrt." Data transformation to apply to the normalized data.}

\item{codefile}{}
}
\description{
Generate a \code{.Rmd} file containing code to normalize data.
}
\details{
The \code{length.matrix} field of the \code{phyloCompData}
object is used to normalize the counts. 
\describe{
\item{\code{none}:}{No length normalization.}
\item{\code{TPM}:}{The raw counts are divided by the length of their associated genes before normalization by \code{voom}.}
\item{\code{RPKM}:}{The log2 length is substracted to the log2 CPM computed by \code{voom} for each gene and sample.}
}
}
\keyword{internal}
