% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic-qc-checks.R
\name{perCellChrQC}
\alias{perCellChrQC}
\title{perCellChrQC}
\usage{
perCellChrQC(
  sampleName,
  chroms = c("chr1", "chr7", "chr15"),
  path,
  barcodeFile = NULL,
  doPlot = TRUE
)
}
\arguments{
\item{sampleName, }{the name of the sample to parse which is used as prefix
for finding relevant files for the underlying sample}

\item{chroms, }{the character vectors of chromosomes to parse. Multiple
chromosomes' results will be concated together.}

\item{path, }{the path to the files, with name patterns *{chrom}_vi.mtx,
*{chrom}_viSegInfo.txt, end with slash}

\item{barcodeFile, }{defaults to NULL, it is assumed to be in the same d
irectory as the other files and with name sampleName_barcodes.txt}

\item{doPlot, }{whether a plot should returned, default to TRUE}
}
\value{
a list object that contains the data.frame with summarised statistics
per chr per cell and a plot (if doPlot)
}
\description{
A function that parses output ('_viSegInfo.txt' )from `sgcocaller`
\url{https://gitlab.svi.edu.au/biocellgen-public/sgcocaller} and
generate cell cell (per chr) summary statistics
}
\examples{
demo_path <-system.file("extdata",package = "comapr")
pcQC <- perCellChrQC(sampleName="s1",chroms=c("chr1"),
path=demo_path,
barcodeFile=NULL)
}
\author{
Ruqian Lyu
}
