% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-hap-state.R
\name{.filterCOsExtra}
\alias{.filterCOsExtra}
\title{Filter out doublet cells and uninformative SNPs}
\usage{
.filterCOsExtra(
  se,
  minSNP = 30,
  minlogllRatio = 200,
  minCellSNP = 200,
  bpDist = 100,
  maxRawCO = 10,
  biasTol = 0.45,
  nmad = 1.5
)
}
\arguments{
\item{se, }{the SummarizedExperiment object that contains the called haplotype
state matrix in the assay field and haplotype segment information in the metadata
field.}

\item{minSNP, }{the crossover(s) will be filtered out if introduced by a segment
that has fewer than `minSNP` SNPs to support.}

\item{minlogllRatio, }{the crossover(s) will be filtered out if introduced by a
segment that has lower than `minlogllRatio` to its reversed state.}

\item{minCellSNP, }{the minimum number of SNPs detected for a cell to be kept,
used with `nmads`}

\item{bpDist, }{the crossover(s) will be filtered out if introduced by a segment
that is shorter than `bpDist` basepairs.}

\item{maxRawCO, }{if a cell has more than `maxRawCO` number of raw crossovers
called across a chromosome, the cell is filtered out}

\item{biasTol, }{the SNP's haplotype ratio across all cells is assumed
to be 1:1. This argument can be used for removing SNPs that have a biased
haplotype. i.e. almost always inferred to be haplotype state 1. It specifies
a bias tolerance value, SNPs with haplotype ratios deviating from 0.5 smaller
than this value are kept. Only effective when number of cells are larger than
10}

\item{nmad, }{how many mean absolute deviations lower than the median number
of SNPs per cellfor a cell to be considered as low coverage cell and filtered
Only effective when number of cells are larger than 10. When effective, this or
`minCellSNP`, whichever is larger, is applied}
}
\value{
A `RangedSummarizedExperment` object that have different dims with input.
the colnames are the cell barcodes, rowRanges specify the location of SNPs that
contribute to crossovers.
}
\description{
This function filter out cells that have been called too many crossovers due
to diploid cell contamination or doublets. It also only keeps SNPs (rows) that
ever contribute to a crossover interval. This function should be run for
individual chromosomes and is called internaly by `readHapState`
}
\details{
The `logllRatio` value is returned by `sgcocaller` for each haplotype
segment formed by consecutive SNPs that are called to have a same state. It is
calculated by taking log of ratio (likelihood of SNPs with inferred states)
and (likelihood of SNPs with reversed states)
}
\author{
Ruqian Lyu
}
\keyword{internal}
