% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene2set.R
\name{gene2set}
\alias{gene2set}
\alias{annotationListToMatrix}
\title{generate relationship between genes and gene-sets}
\usage{
gene2set(annofile = NULL, genenames, TermFreq = 0)

annotationListToMatrix(annotation, genenames)
}
\arguments{
\item{annofile}{a gmt file. Examples are from MSigDB Collections.
A list of gene set could be find in the vignette of cogena}

\item{genenames}{a SYMBOL gene names charactic vector.}

\item{TermFreq}{a threshold for the Term Frequence. Default is zero.}

\item{annotation}{a value returned by \code{\link{gmt2list}}.}
}
\value{
an gene and gene-set relationship matrix
}
\description{
Generate relationship between genes (gene SYMBOL) and gene-sets, 
such as Pathway or GO.
}
\examples{
data(Psoriasis)

#annotaion
annoGMT <- "c2.cp.kegg.v7.01.symbols.gmt.xz"
annofile <- system.file("extdata", annoGMT, package="cogena")
# the DEG gene-sets matrix
anno <- gene2set(annofile, rownames(DEexprs))
}
