% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codonTable-class.R
\docType{class}
\name{codonTable-class}
\alias{codonTable-class}
\alias{codonTable}
\alias{codonTable,DNAStringSet-method}
\alias{codonTable,matrix-method}
\alias{codonTable,data.frame-method}
\alias{codonCounts}
\alias{codonCounts,codonTable-method}
\alias{getID}
\alias{getID,codonTable-method}
\alias{getlen}
\alias{getlen,codonTable-method}
\alias{getKO}
\alias{getKO,codonTable-method}
\alias{setKO}
\alias{setKO,codonTable-method}
\alias{getCOG}
\alias{getCOG,codonTable-method}
\alias{setCOG}
\alias{setCOG,codonTable-method}
\title{An S4 class \code{codonTable}}
\usage{
codonTable(x)

\S4method{codonTable}{DNAStringSet}(x)

\S4method{codonTable}{matrix}(x)

\S4method{codonTable}{data.frame}(x)

codonCounts(object)

\S4method{codonCounts}{codonTable}(object)

getID(object)

\S4method{getID}{codonTable}(object)

getlen(object)

\S4method{getlen}{codonTable}(object)

getKO(object)

\S4method{getKO}{codonTable}(object)

setKO(object, ann)

\S4method{setKO}{codonTable}(object, ann)

getCOG(object)

\S4method{getCOG}{codonTable}(object)

setCOG(object, ann)

\S4method{setCOG}{codonTable}(object, ann)
}
\arguments{
\item{x}{An object of \code{DNAStringSet}, \code{matrix} or
\code{data.frame} class.}

\item{object}{A \code{codonTable} object.}

\item{ann}{A character vector of sequence annotations,
must be of length equal to \code{length(object)}.}
}
\value{
A \code{codonTable}.
}
\description{
Contains codon counts and optional annotation
for a set DNA sequences.
}
\section{Methods (by generic)}{
\itemize{
\item \code{codonTable}: Create new objects of class \code{codonTable}.

\item \code{codonCounts}: Get codon counts from \code{codonTable} object.

\item \code{getID}: Get IDs for \code{codonTable} class.

\item \code{getlen}: Get lengths of sequences in \code{codonTable} object.

\item \code{getKO}: Get KO annotations of sequences
in \code{codonTable} object.

\item \code{setKO}: Set KO annotations
for \code{codonTable} object.

\item \code{getCOG}: Get COG annotations of sequences
in \code{codonTable} object.

\item \code{setCOG}: Set COG annotations
for \code{codonTable} object.
}}

\section{Slots}{

\describe{
\item{\code{ID}}{A character vector of sequence identifiers.}

\item{\code{counts}}{A matrix containing codon counts.
Columns are codons, rows are sequences.}

\item{\code{len}}{A numeric vector,length equal to \code{nrow(counts)},
containing lengths of sequnces.}

\item{\code{KO}}{A character vector of KEGG annotations for sequences,
length equal to \code{nrow(counts)}. If no annotation
is available, this will be an empty vector.}

\item{\code{COG}}{A character vector of COG annotations for sequences,
length equal to \code{nrow(counts)}. If no annotation
is available, this will be an empty vector.}
}}

\examples{
# create codonTable with codon counts for sequences in DNAStringSet
require(Biostrings)
dna <- DNAStringSet(c("ACGAAGTGTACTGTAATTTGCACAGTACTTAAATGT",
                      "ACGTCCGTACTGATCGATTCCGTGATT"))
cT <- codonTable(dna)
codonCounts(cT)
getlen(cT)
getKO(cT)
cT <- setKO(cT, c("K00001", "K00002"))
getKO(cT)

# convert matrix containing codon counts to codonTable
mat <- matrix(sample(1:10, 122, replace = TRUE), nrow = 2)
codonTable(mat) # produces informative warning

}
