% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/io.R
\name{write.gct}
\alias{write.gct}
\alias{write_gct}
\title{Write a GCT object to disk in GCT format}
\usage{
write.gct(...)

write_gct(ds, ofile, precision = 4, appenddim = TRUE, ver = 3)
}
\arguments{
\item{...}{arguments passed on to \code{write_gct}}

\item{ds}{the GCT object}

\item{ofile}{the desired output filename}

\item{precision}{the numeric precision at which to
save the matrix. See \code{details}.}

\item{appenddim}{boolean indicating whether to append
matrix dimensions to filename}

\item{ver}{the GCT version to write. See \code{details}.}
}
\value{
silently returns NULL
}
\description{
Write a GCT object to disk in GCT format
}
\details{
Since GCT is text format, the higher \code{precision}
  you choose, the larger the file size.
  \code{ver} is assumed to be 3, aka GCT version 1.3, which supports
  embedded row and column metadata in the GCT file. Any other value
  passed to \code{ver} will result in a GCT version 1.2 file which
  contains only the matrix data and no annotations.
}
\examples{
# note this will create a GCT file in your current directory
write_gct(ds, "dataset", precision=2)

}
\seealso{
Other GCTX parsing functions: 
\code{\link{GCT}},
\code{\link{append.dim}()},
\code{\link{fix.datatypes}()},
\code{\link{parse.gctx}()},
\code{\link{process_ids}()},
\code{\link{read.gctx.ids}()},
\code{\link{read.gctx.meta}()},
\code{\link{write.gctx.meta}()},
\code{\link{write.gctx}()}
}
\concept{GCTX parsing functions}
