% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{lxb2mat}
\alias{lxb2mat}
\title{Read an LXB file and return a matrix}
\usage{
lxb2mat(lxb_path, columns = c("RID", "RP1"), newnames = c("barcode_id", "FI"))
}
\arguments{
\item{lxb_path}{the path to the lxb file}

\item{columns}{which columns in the lxb file to retain}

\item{newnames}{what to name these columns in the returned matrix}
}
\value{
a matrix
}
\description{
Read an LXB file and return a matrix
}
\examples{
lxb_path <- system.file("extdata", "example.lxb", package="cmapR")
lxb_data <- lxb2mat(lxb_path)
str(lxb_data)

}
\seealso{
Other CMap parsing functions: 
\code{\link{parse.gmt}()},
\code{\link{parse.gmx}()},
\code{\link{parse.grp}()},
\code{\link{write_gmt}()},
\code{\link{write_grp}()}
}
\concept{CMap parsing functions}
