% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ref_feature_select}
\alias{ref_feature_select}
\title{feature select from reference matrix}
\usage{
ref_feature_select(mat, n = 3000, mode = "var", rm.lowvar = TRUE)
}
\arguments{
\item{mat}{reference matrix}

\item{n}{number of genes to return}

\item{mode}{the method of selecting features}

\item{rm.lowvar}{whether to remove lower variation genes first}
}
\value{
vector of genes
}
\description{
feature select from reference matrix
}
\examples{
pbmc_avg <- average_clusters(
    mat = pbmc_matrix_small,
    metadata = pbmc_meta,
    cluster_col = "classified"
)

ref_feature_select(
    mat = pbmc_avg[1:100, ],
    n = 5
)
}
