% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_best_call}
\alias{plot_best_call}
\title{Plot best calls for each cluster on a tSNE or umap}
\usage{
plot_best_call(
  cor_mat,
  metadata,
  cluster_col = "cluster",
  collapse_to_cluster = FALSE,
  threshold = 0,
  x = "UMAP_1",
  y = "UMAP_2",
  plot_r = FALSE,
  per_cell = FALSE,
  ...
)
}
\arguments{
\item{cor_mat}{input similarity matrix}

\item{metadata}{input metadata with tsne or
umap coordinates and cluster ids}

\item{cluster_col}{metadata column, can be cluster or cellid}

\item{collapse_to_cluster}{if a column name is provided,
takes the most frequent call of entire cluster to color in plot}

\item{threshold}{minimum correlation coefficent cutoff for calling clusters}

\item{x}{x variable}

\item{y}{y variable}

\item{plot_r}{whether to include second plot of cor eff for best call}

\item{per_cell}{whether the cor_mat was generate per cell or per cluster}

\item{...}{passed to plot_dims}
}
\value{
ggplot object, cells projected by dr,
colored by cell type classification
}
\description{
Plot best calls for each cluster on a tSNE or umap
}
\examples{
res <- clustify(
    input = pbmc_matrix_small,
    metadata = pbmc_meta,
    ref_mat = cbmc_ref,
    query_genes = pbmc_vargenes,
    cluster_col = "classified"
)

plot_best_call(
    cor_mat = res,
    metadata = pbmc_meta,
    cluster_col = "classified"
)
}
