% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_genelist.R
\name{matrixize_markers}
\alias{matrixize_markers}
\title{Convert candidate genes list into matrix}
\usage{
matrixize_markers(
  marker_df,
  ranked = FALSE,
  n = NULL,
  step_weight = 1,
  background_weight = 0,
  unique = FALSE,
  metadata = NULL,
  cluster_col = "classified",
  remove_rp = FALSE
)
}
\arguments{
\item{marker_df}{dataframe of candidate genes, must contain
"gene" and "cluster" columns, or a matrix of gene names to
convert to ranked}

\item{ranked}{unranked gene list feeds into hyperp, the ranked
gene list feeds into regular corr_coef}

\item{n}{number of genes to use}

\item{step_weight}{ranked genes are tranformed into pseudo
expression by descending weight}

\item{background_weight}{ranked genes are tranformed into pseudo
expression with added weight}

\item{unique}{whether to use only unique markers to 1 cluster}

\item{metadata}{vector or dataframe of cluster names, should
have column named cluster}

\item{cluster_col}{column for cluster names to replace original
cluster, if metadata is dataframe}

\item{remove_rp}{do not include rps, rpl, rp1-9 in markers}
}
\value{
matrix of unranked gene marker names, or matrix of
ranked expression
}
\description{
Convert candidate genes list into matrix
}
\examples{
matrixize_markers(pbmc_markers)
}
