% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_dplyr.R
\name{call_to_metadata}
\alias{call_to_metadata}
\title{Insert called ident results into metadata}
\usage{
call_to_metadata(
  res,
  metadata,
  cluster_col,
  per_cell = FALSE,
  rename_prefix = NULL
)
}
\arguments{
\item{res}{dataframe of idents, such as output of cor_to_call}

\item{metadata}{input metadata with tsne or umap coordinates and cluster ids}

\item{cluster_col}{metadata column, can be cluster or cellid}

\item{per_cell}{whether the res dataframe is listed per cell}

\item{rename_prefix}{prefix to add to type and r column names}
}
\value{
new metadata with added columns
}
\description{
Insert called ident results into metadata
}
\examples{
res <- clustify(
    input = pbmc_matrix_small,
    metadata = pbmc_meta,
    cluster_col = "classified",
    ref_mat = cbmc_ref
)

res2 <- cor_to_call(res, cluster_col = "classified")

call_to_metadata(
    res = res2,
    metadata = pbmc_meta,
    cluster_col = "classified",
    rename_prefix = "assigned"
)
}
