% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enricher.R
\name{GSEA}
\alias{GSEA}
\title{GSEA}
\usage{
GSEA(
  geneList,
  exponent = 1,
  minGSSize = 10,
  maxGSSize = 500,
  eps = 1e-10,
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  gson = NULL,
  TERM2GENE,
  TERM2NAME = NA,
  verbose = TRUE,
  seed = FALSE,
  by = "fgsea",
  ...
)
}
\arguments{
\item{geneList}{order ranked geneList}

\item{exponent}{weight of each step}

\item{minGSSize}{minimal size of each geneSet for analyzing}

\item{maxGSSize}{maximal size of genes annotated for testing}

\item{eps}{This parameter sets the boundary for calculating the p value.}

\item{pvalueCutoff}{adjusted pvalue cutoff}

\item{pAdjustMethod}{one of "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none"}

\item{gson}{a GSON object, if not NULL, use it as annotation data.}

\item{TERM2GENE}{user input annotation of TERM TO GENE mapping, a data.frame of 2 column with term and gene.
Only used when gson is NULL.}

\item{TERM2NAME}{user input of TERM TO NAME mapping, a data.frame of 2 column with term and name.
Only used when gson is NULL.}

\item{verbose}{logical}

\item{seed}{logical}

\item{by}{one of 'fgsea' or 'DOSE'}

\item{...}{other parameter}
}
\value{
gseaResult object
}
\description{
a universal gene set enrichment analysis tools
}
\author{
Guangchuang Yu \url{https://yulab-smu.top}
}
